/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.websocket.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class MessageStats
extends UrlStats {
    private final AtomicLong traffic = new AtomicLong(0L);
    private final AtomicInteger createSessionCount = new AtomicInteger(0);
    private final AtomicInteger closeSessionCount = new AtomicInteger(0);
    private final AtomicReference<String> closeReason = new AtomicReference();

    public void createSession() {
        this.createSessionCount.incrementAndGet();
    }

    public void closeSession(String closeReasonStr) {
        this.closeSessionCount.incrementAndGet();
        this.closeReason.set(closeReasonStr);
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public void incrementTraffic(long trafficCount) {
        this.traffic.addAndGet(trafficCount);
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.add("traffic", (Object)this.traffic.get());
        row.add("createSessionCount", (Object)this.createSessionCount.get());
        row.add("closeSessionCount", (Object)this.closeSessionCount.get());
        row.add("closeReason", (Object)this.closeReason.get());
        row.remove((Object)"concurrentMax");
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.add("traffic", (Object)this.traffic.getAndSet(0L));
        row.add("createSessionCount", (Object)this.createSessionCount.getAndSet(0));
        row.add("closeSessionCount", (Object)this.closeSessionCount.getAndSet(0));
        row.add("closeReason", this.closeReason.getAndSet(null));
        row.remove((Object)"concurrentMax");
        return row;
    }
}

