/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.redis.collector;

import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.common.StatsStore;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.redis.collector.RedisDetailAggregator;
import com.lubanops.apm.plugin.redis.collector.RedisStats;
import java.util.concurrent.atomic.AtomicReference;

public class RedisStatsStore
implements StatsStore<RedisStats> {
    private static final Logger LOGGER = LogFactory.getLogger();
    private final int maxActionCount;
    private final int maxHostCount;
    private AtomicReference<RedisStats>[][] ref;

    RedisStatsStore(int maxActionCount, int maxHostCount) {
        this.maxActionCount = maxActionCount;
        this.maxHostCount = maxHostCount;
        this.initRef(maxActionCount, maxHostCount);
    }

    private void initRef(int maxActionCount, int maxHostCount) {
        this.ref = new AtomicReference[maxActionCount][maxHostCount];
        for (int i = 0; i < maxActionCount; ++i) {
            for (int j = 0; j < maxHostCount; ++j) {
                this.ref[i][j] = new AtomicReference();
            }
        }
    }

    public RedisStats get(PrimaryKey pks) {
        String action = pks.get(0);
        String host = pks.get(1);
        if (StringUtils.isBlank((String)action)) {
            LOGGER.severe("get status by primary key,but action is null");
        }
        if (StringUtils.isBlank((String)host)) {
            LOGGER.severe("get status by primary key,but action is null");
        }
        int actionIndex = RedisDetailAggregator.REDIS_ACTION_MAP.registerResource(action);
        int hostIndex = RedisDetailAggregator.REDIS_CONNECTION_ID_MAP.registerResource(host);
        if (actionIndex == -1 || hostIndex == -1) {
            return null;
        }
        AtomicReference<RedisStats> redisStatsRef = this.ref[actionIndex][hostIndex];
        RedisStats redisStats = redisStatsRef.get();
        if (redisStats != null) {
            return redisStats;
        }
        redisStats = new RedisStats();
        boolean suc = redisStatsRef.compareAndSet(null, redisStats);
        if (suc) {
            return redisStats;
        }
        return redisStatsRef.get();
    }

    public void clear() {
        this.initRef(this.maxActionCount, this.maxHostCount);
    }
}

