/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.httpclient.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class InvocationStats
extends DefaultSectionStats {
    private final AtomicInteger responseCloseCount = new AtomicInteger(0);
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private String hostUri;
    private String envId;

    public void onThrowable(Throwable t) {
        super.onThrowable(t);
    }

    public boolean onResponseClose(long start) {
        boolean flag = super.onFinally(System.nanoTime() - start);
        this.responseCloseCount.incrementAndGet();
        return flag;
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public String getHostUri() {
        return this.hostUri;
    }

    public void setHostUri(String hostUri) {
        this.hostUri = hostUri;
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    public void incrementErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put((Object)"responseCloseCount", (Object)this.responseCloseCount.get());
        row.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        row.put((Object)"hostUri", (Object)this.hostUri);
        if (this.envId != null) {
            row.put((Object)"envId", (Object)this.envId);
        }
        return row;
    }

    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row == null) {
            return null;
        }
        row.put((Object)"responseCloseCount", (Object)this.responseCloseCount.getAndSet(0));
        row.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        row.put((Object)"hostUri", (Object)this.hostUri);
        if (this.envId != null) {
            row.put((Object)"envId", (Object)this.envId);
        }
        return row;
    }

    public String getEnvId() {
        return this.envId;
    }

    public void setEnvId(String envId) {
        this.envId = envId;
    }
}

