/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTypedMultiNames;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.Arrays;

public class JSONPathTypedMultiNamesPrefixName1
extends JSONPathTypedMultiNames {
    final JSONPathSingleName prefixName;
    final long prefixNameHash;

    JSONPathTypedMultiNamesPrefixName1(JSONPath[] paths, JSONPath prefix, JSONPath[] namePaths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, long features) {
        super(paths, prefix, namePaths, types, formats, pathFeatures, zoneId, features);
        this.prefixName = (JSONPathSingleName)prefix;
        this.prefixNameHash = this.prefixName.nameHashCode;
    }

    @Override
    public Object extract(JSONReader jsonReader) {
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        while (true) {
            boolean match;
            if (jsonReader.nextIfObjectEnd()) {
                return new Object[this.paths.length];
            }
            if (jsonReader.isEnd()) {
                throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
            }
            long nameHashCode = jsonReader.readFieldNameHashCode();
            boolean bl = match = nameHashCode == this.prefixNameHash;
            if (match) break;
            jsonReader.skipValue();
        }
        if (jsonReader.nextIfNull()) {
            return new Object[this.paths.length];
        }
        if (!jsonReader.nextIfObjectStart()) {
            throw new JSONException(jsonReader.info("illegal input, expect '[', but " + jsonReader.current()));
        }
        Object[] values = new Object[this.paths.length];
        while (!jsonReader.nextIfObjectEnd()) {
            Object fieldValue;
            long nameHashCode = jsonReader.readFieldNameHashCode();
            int m = Arrays.binarySearch(this.hashCodes, nameHashCode);
            if (m < 0) {
                jsonReader.skipValue();
                continue;
            }
            short index = this.mapping[m];
            FieldReader fieldReader = this.fieldReaders[index];
            try {
                fieldValue = fieldReader.readFieldValue(jsonReader);
            }
            catch (Exception e) {
                long features = 0L;
                if (index < this.pathFeatures.length) {
                    features = this.pathFeatures[index];
                }
                if ((features & JSONPath.Feature.NullOnError.mask) == 0L) {
                    throw e;
                }
                fieldValue = null;
            }
            values[index] = fieldValue;
        }
        return values;
    }
}

