/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.plugin.functiongraph.collector.ServerClusterStatsBase;
import java.util.List;
import java.util.Map;

public class ClusterAggregator
extends SinglePrimaryKeyAggregator<ServerClusterStatsBase> {
    private static final ThreadLocal<String> ENVID_THREADLOCAL = new ThreadLocal();

    public String getName() {
        return "cluster";
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    protected Class<ServerClusterStatsBase> getValueType() {
        return ServerClusterStatsBase.class;
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public void onStart(String envId) {
        ENVID_THREADLOCAL.set(envId);
    }

    public void onFinally(long t, boolean hasError) {
        String envId = ENVID_THREADLOCAL.get();
        if (envId != null) {
            ENVID_THREADLOCAL.set(null);
            ServerClusterStatsBase stats = (ServerClusterStatsBase)this.getValue(envId);
            stats.getInvokeCount().incrementAndGet();
            stats.getTotalTime().addAndGet(t);
            if (hasError) {
                stats.getErrorCount().incrementAndGet();
            }
        }
    }

    protected String primaryKey() {
        return "clusterId";
    }
}

