/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mariadb.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlTrace;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.mariadb.interceptor.PreparedStatementInteceptor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.mariadb.jdbc.internal.com.read.resultset.SelectResultSet;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;

public class PreparedStatementExecuteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MysqlCollector.INSTANCE.isEnable() && object instanceof AttributeAccess) {
                PreparedStatement preparedStatement = (PreparedStatement)object;
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                Integer id = PreparedStatementInteceptor.getConnectionId(preparedStatement);
                PreparedStatementInteceptor.onStart(sql, id);
                MysqlTrace.onStart((String)className, (String)methodName, (String)sql, null, (Integer)id);
                this.setOriginSql(fields);
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
        }
        return new Object[0];
    }

    private String getSql(Object[] fields) {
        String sql = (String)fields[0];
        if (null == sql) {
            sql = (String)fields[3];
        }
        return sql;
    }

    private void setOriginSql(Object[] fields) {
        if (MysqlCollector.CONFIG.isParseOriginSql()) {
            String parameters;
            int parameterCount;
            int parameterCountLimit = 20;
            StringBuilder parameter = new StringBuilder();
            if (fields[1] != null && fields[1] instanceof ParameterHolder[]) {
                for (ParameterHolder parameterHolder : (ParameterHolder[])fields[1]) {
                    if (parameterCount <= parameterCountLimit) {
                        if (parameterCount == 0) {
                            parameter.append(parameterHolder.toString());
                        } else {
                            parameter.append(",").append(parameterHolder.toString());
                        }
                        ++parameterCount;
                        continue;
                    }
                    break;
                }
            } else if (fields[2] != null && fields[2] instanceof Map) {
                Iterator it = ((Map)fields[2]).values().iterator();
                for (parameterCount = 0; it.hasNext() && parameterCount <= parameterCountLimit; ++parameterCount) {
                    ParameterHolder parameterHolder = (ParameterHolder)it.next();
                    if (parameterCount == 0) {
                        parameter.append(parameterHolder.toString());
                        continue;
                    }
                    parameter.append(",").append(parameterHolder.toString());
                }
            }
            if (!StringUtils.isBlank((String)(parameters = parameter.toString()))) {
                TraceCollector.addTag((String)"parameters", (String)parameters);
            }
        }
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (object instanceof AttributeAccess) {
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                PreparedStatementInteceptor.onError(e, sql);
                MysqlTrace.onError((Throwable)e);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        block7: {
            try {
                if (!(object instanceof AttributeAccess)) break block7;
                Object[] fields = ((AttributeAccess)object).getLopsFileds();
                String sql = this.getSql(fields);
                PreparedStatement preparedStatement = (PreparedStatement)object;
                int updatedRowCount = 0;
                int readRowCount = 0;
                ResultSet resultSet = null;
                try {
                    updatedRowCount = preparedStatement.getUpdateCount();
                    resultSet = preparedStatement.getResultSet();
                    if (resultSet != null && resultSet instanceof SelectResultSet) {
                        readRowCount = ((SelectResultSet)resultSet).getDataSize();
                    }
                }
                catch (SQLException e) {
                    LogFactory.getLogger().log(Level.SEVERE, "sql result error", (Throwable)e);
                }
                MysqlCollector.onFinally((int)updatedRowCount, (int)readRowCount);
                if (resultSet != null && resultSet instanceof TransformAccess) {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, (TransformAccess)((TransformAccess)resultSet));
                } else {
                    MysqlTrace.onFinally((int)updatedRowCount, (int)readRowCount, null);
                }
                MysqlCollector.onConnectionEnd((String)sql, (int)updatedRowCount, (int)readRowCount);
            }
            catch (Exception e) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e);
            }
        }
    }
}

