/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.text;

import com.taobao.text.Style;
import java.io.IOException;

public abstract class Format {
    public static final Text TEXT = new Text();
    public static final Ansi ANSI = new Ansi();
    public static final PreHtml PRE_HTML = new PreHtml();

    public abstract void begin(Appendable var1) throws IOException;

    public abstract void write(CharSequence var1, Appendable var2) throws IOException;

    public abstract void write(char var1, Appendable var2) throws IOException;

    public abstract void write(Style var1, Appendable var2) throws IOException;

    public abstract void cls(Appendable var1) throws IOException;

    public abstract void end(Appendable var1) throws IOException;

    public static class PreHtml
    extends Format {
        protected PreHtml() {
        }

        @Override
        public void begin(Appendable to) throws IOException {
            to.append("<pre>");
        }

        @Override
        public void write(CharSequence s, Appendable to) throws IOException {
            if (s.length() > 0) {
                for (int i = 0; i < s.length(); ++i) {
                    this.write(s.charAt(i), to);
                }
            }
        }

        @Override
        public void write(char c, Appendable to) throws IOException {
            switch (c) {
                case '>': {
                    to.append("&gt;");
                    break;
                }
                case '<': {
                    to.append("&lt;");
                    break;
                }
                case '&': {
                    to.append("&amp;");
                    break;
                }
                case '\'': {
                    to.append("&#039;");
                    break;
                }
                case '\"': {
                    to.append("&#034;");
                    break;
                }
                default: {
                    to.append(c);
                }
            }
        }

        @Override
        public void write(Style style, Appendable to) throws IOException {
        }

        @Override
        public void cls(Appendable to) throws IOException {
        }

        @Override
        public void end(Appendable to) throws IOException {
            to.append("</pre>");
        }
    }

    public static class Ansi
    extends Format {
        protected Ansi() {
        }

        @Override
        public void begin(Appendable to) throws IOException {
        }

        @Override
        public void write(CharSequence s, Appendable to) throws IOException {
            if (s.length() > 0) {
                to.append(s);
            }
        }

        @Override
        public void write(char c, Appendable to) throws IOException {
            to.append(c);
        }

        @Override
        public void write(Style style, Appendable to) throws IOException {
            style.writeAnsiTo(to);
        }

        @Override
        public void cls(Appendable to) throws IOException {
        }

        @Override
        public void end(Appendable to) throws IOException {
        }
    }

    public static class Text
    extends Format {
        protected Text() {
        }

        @Override
        public void begin(Appendable to) throws IOException {
        }

        @Override
        public void write(CharSequence s, Appendable to) throws IOException {
            if (s.length() > 0) {
                to.append(s);
            }
        }

        @Override
        public void write(char c, Appendable to) throws IOException {
            to.append(c);
        }

        @Override
        public void write(Style style, Appendable to) throws IOException {
        }

        @Override
        public void cls(Appendable to) throws IOException {
        }

        @Override
        public void end(Appendable to) throws IOException {
        }
    }
}

