/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.converters;

import com.huawei.cloud.profiler.pap.v1.PDebuggerRequest;
import com.huawei.cloud.profiler.pap.v1.PDebuggerResponse;
import com.lubanops.apm.integration.debugger.converters.ArthasModelToPDebuggerConverter;
import com.taobao.arthas.core.command.model.FieldVO;
import com.taobao.arthas.core.command.model.SearchClassModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SearchClassModelToPDebuggerResponseConverter
extends ArthasModelToPDebuggerConverter {
    public static PDebuggerResponse convert(Set<SearchClassModel> searchClassModels, PDebuggerRequest request) {
        ArrayList<PDebuggerResponse.ClassDetailVO> classInfoList = new ArrayList<PDebuggerResponse.ClassDetailVO>();
        for (SearchClassModel searchClassModel : searchClassModels) {
            PDebuggerResponse.ClassDetailVO.Builder clazzBuilder = PDebuggerResponse.ClassDetailVO.newBuilder().setName(searchClassModel.getClassInfo().getName()).setClassLoaderHash(searchClassModel.getClassInfo().getClassLoaderHash()).setCodeSource(searchClassModel.getClassInfo().getCodeSource()).addAllSuperClass(Arrays.asList(searchClassModel.getClassInfo().getSuperClass()));
            SearchClassModelToPDebuggerResponseConverter.buildFieldsIfAny(clazzBuilder, searchClassModel.getClassInfo().getFields());
            classInfoList.add(clazzBuilder.build());
        }
        PDebuggerResponse.ClassListResponse.newBuilder().addAllClasses(classInfoList).setWithField(request.getPayload().getSearchClassCommand().getIsField()).build();
        PDebuggerResponse.Payload.Builder payloadBuilder = PDebuggerResponse.Payload.newBuilder().setClassListResponse(PDebuggerResponse.ClassListResponse.newBuilder().addAllClasses(classInfoList).build());
        return SearchClassModelToPDebuggerResponseConverter.buildPDebuggerResponse(payloadBuilder, request.getPayload().getPayloadMetadata(), request.getMetadata());
    }

    private static void buildFieldsIfAny(PDebuggerResponse.ClassDetailVO.Builder clazzBuilder, FieldVO[] fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        List protoFields = Arrays.stream(fields).map(arthasField -> SearchClassModelToPDebuggerResponseConverter.toProtoField(arthasField)).collect(Collectors.toList());
        clazzBuilder.addAllFields(protoFields);
    }

    private static PDebuggerResponse.FieldVO toProtoField(FieldVO arthasField) {
        boolean isStatic = false;
        String modifier = arthasField.getModifier();
        if (StringUtils.isNotBlank((CharSequence)modifier)) {
            isStatic = modifier.equalsIgnoreCase("static");
        }
        String[] annotations = arthasField.getAnnotations();
        return PDebuggerResponse.FieldVO.newBuilder().setName(arthasField.getName()).setType(arthasField.getType()).setModifier(arthasField.getModifier()).setIsStatic(isStatic).addAllAnnotations(Arrays.asList(annotations)).build();
    }
}

