/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.handler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;

public class ArthasInterceptors {
    public static final void addInterceptors(Instrumentation instrumentation) {
        instrumentation.addTransformer(new ArthasBootstrapIntercetor());
    }

    private static final class ArthasBootstrapIntercetor
    implements ClassFileTransformer {
        private ArthasBootstrapIntercetor() {
        }

        @Override
        public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            try {
                if (className == null || !className.endsWith("server/ArthasBootstrap")) {
                    return classfileBuffer;
                }
                ClassPool pool = new ClassPool(null);
                LoaderClassPath classPath = new LoaderClassPath(loader);
                pool.appendClassPath((ClassPath)classPath);
                pool.appendSystemPath();
                ByteArrayInputStream ins = new ByteArrayInputStream(classfileBuffer);
                CtClass cc = pool.makeClass((InputStream)ins);
                CtMethod method = cc.getDeclaredMethod("bind");
                method.insertAt(0, "if(true) return ;");
                return cc.toBytecode();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }
}

