/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.server;

import com.lubanops.apm.integration.debugger.server.DebuggerJobImpl;
import com.lubanops.apm.integration.debugger.server.DebuggerProcessImpl;
import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.distribution.ResultDistributor;
import com.taobao.arthas.core.shell.cli.CliToken;
import com.taobao.arthas.core.shell.command.Command;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.command.internal.RedirectHandler;
import com.taobao.arthas.core.shell.command.internal.StdoutHandler;
import com.taobao.arthas.core.shell.command.internal.TermHandler;
import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.impl.InternalCommandManager;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import com.taobao.arthas.core.shell.term.Term;
import com.taobao.arthas.core.shell.term.Tty;
import com.taobao.arthas.core.util.Constants;
import com.taobao.arthas.core.util.LogUtil;
import com.taobao.arthas.core.util.TokenUtils;
import io.termd.core.function.Function;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

public class DebuggerJobController
extends JobControllerImpl {
    private final SortedMap<Integer, DebuggerJobImpl> jobs = new TreeMap<Integer, DebuggerJobImpl>();
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private boolean closed = false;

    public Set<Job> jobs() {
        return new HashSet<Job>(this.jobs.values());
    }

    public Job getJob(int id) {
        return (Job)this.jobs.get(id);
    }

    public Job createJob(InternalCommandManager commandManager, List<CliToken> tokens, Session session, JobListener jobHandler, Term term, ResultDistributor resultDistributor) {
        int jobId = this.idGenerator.incrementAndGet();
        StringBuilder line = new StringBuilder();
        for (CliToken arg : tokens) {
            line.append(arg.raw());
        }
        boolean runInBackground = this.runInBackground(tokens);
        Process process = this.createProcess(session, tokens, commandManager, jobId, term, resultDistributor);
        process.setJobId(jobId);
        DebuggerJobImpl job = new DebuggerJobImpl(jobId, this, process, line.toString(), runInBackground, session, jobHandler);
        return job;
    }

    private int getRedirectJobCount() {
        int count = 0;
        for (Job job : this.jobs.values()) {
            if (job.process() == null || job.process().cacheLocation() == null) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(final Handler<Void> completionHandler) {
        List<DebuggerJobImpl> jobs;
        DebuggerJobController debuggerJobController = this;
        synchronized (debuggerJobController) {
            if (this.closed) {
                jobs = Collections.emptyList();
            } else {
                jobs = new ArrayList<DebuggerJobImpl>(this.jobs.values());
                this.closed = true;
            }
        }
        if (jobs.isEmpty()) {
            if (completionHandler != null) {
                completionHandler.handle(null);
            }
        } else {
            final AtomicInteger count = new AtomicInteger(jobs.size());
            for (DebuggerJobImpl job : jobs) {
                job.terminateFuture.setHandler((Handler)new Handler<Future<Void>>(){

                    public void handle(Future<Void> v) {
                        if (count.decrementAndGet() == 0 && completionHandler != null) {
                            completionHandler.handle(null);
                        }
                    }
                });
                job.terminate();
            }
        }
    }

    private Process createProcess(Session session, List<CliToken> line, InternalCommandManager commandManager, int jobId, Term term, ResultDistributor resultDistributor) {
        try {
            ListIterator<CliToken> tokens = line.listIterator();
            while (tokens.hasNext()) {
                CliToken token = tokens.next();
                if (!token.isText()) continue;
                Command command = commandManager.getCommand(token.value());
                if (command != null) {
                    return this.createCommandProcess(command, tokens, jobId, term, resultDistributor);
                }
                throw new IllegalArgumentException(token.value() + ": command not found");
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean runInBackground(List<CliToken> tokens) {
        boolean runInBackground = false;
        CliToken last = TokenUtils.findLastTextToken(tokens);
        if (last != null && "&".equals(last.value())) {
            runInBackground = true;
            tokens.remove(last);
        }
        return runInBackground;
    }

    private Process createCommandProcess(Command command, ListIterator<CliToken> tokens, int jobId, Term term, ResultDistributor resultDistributor) throws IOException {
        ArrayList<CliToken> remaining = new ArrayList<CliToken>();
        ArrayList<CliToken> pipelineTokens = new ArrayList<CliToken>();
        boolean isPipeline = false;
        RedirectHandler redirectHandler = null;
        ArrayList<Function<String, String>> stdoutHandlerChain = new ArrayList<Function<String, String>>();
        String cacheLocation = null;
        while (tokens.hasNext()) {
            CliToken remainingToken = tokens.next();
            if (remainingToken.isText()) {
                String tokenValue = remainingToken.value();
                if ("|".equals(tokenValue)) {
                    isPipeline = true;
                    this.injectHandler(stdoutHandlerChain, pipelineTokens);
                    continue;
                }
                if (">>".equals(tokenValue) || ">".equals(tokenValue)) {
                    String name = this.getRedirectFileName(tokens);
                    if (name == null) {
                        cacheLocation = name = LogUtil.cacheDir() + File.separator + Constants.PID + File.separator + jobId;
                        if (this.getRedirectJobCount() == 8) {
                            throw new IllegalStateException("The amount of async command that saving result to file can't > 8");
                        }
                    }
                    redirectHandler = new RedirectHandler(name, ">>".equals(tokenValue));
                    break;
                }
            }
            if (isPipeline) {
                pipelineTokens.add(remainingToken);
                continue;
            }
            remaining.add(remainingToken);
        }
        this.injectHandler(stdoutHandlerChain, pipelineTokens);
        if (redirectHandler != null) {
            stdoutHandlerChain.add((Function<String, String>)redirectHandler);
        } else {
            stdoutHandlerChain.add((Function<String, String>)new TermHandler(term));
            if (GlobalOptions.isSaveResult) {
                stdoutHandlerChain.add((Function<String, String>)new RedirectHandler());
            }
        }
        DebuggerProcessImpl.ProcessOutput ProcessOutput2 = new DebuggerProcessImpl.ProcessOutput(stdoutHandlerChain, cacheLocation, (Tty)term);
        DebuggerProcessImpl process = new DebuggerProcessImpl(command, remaining, (Handler<CommandProcess>)command.processHandler(), ProcessOutput2, resultDistributor);
        process.setTty((Tty)term);
        return process;
    }

    private String getRedirectFileName(ListIterator<CliToken> tokens) {
        while (tokens.hasNext()) {
            CliToken token = tokens.next();
            if (!token.isText()) continue;
            return token.value();
        }
        return null;
    }

    private void injectHandler(List<Function<String, String>> stdoutHandlerChain, List<CliToken> pipelineTokens) {
        if (!pipelineTokens.isEmpty()) {
            StdoutHandler handler = StdoutHandler.inject(pipelineTokens);
            if (handler != null) {
                stdoutHandlerChain.add((Function<String, String>)handler);
            }
            pipelineTokens.clear();
        }
    }

    public void close() {
        this.close(null);
    }

    synchronized boolean removeJob(int id) {
        return this.jobs.remove(id) != null;
    }
}

