/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.server;

import com.taobao.arthas.core.shell.future.Future;
import com.taobao.arthas.core.shell.handlers.Handler;
import com.taobao.arthas.core.shell.session.Session;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.Job;
import com.taobao.arthas.core.shell.system.JobListener;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.impl.JobControllerImpl;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebuggerJobImpl
implements Job {
    final int id;
    final JobControllerImpl controller;
    final Process process;
    final String line;
    private volatile Session session;
    private volatile ExecStatus actualStatus;
    volatile long lastStopped;
    volatile JobListener jobHandler;
    volatile Handler<ExecStatus> statusUpdateHandler;
    volatile Date timeoutDate;
    final Future<Void> terminateFuture;
    final AtomicBoolean runInBackground;

    public DebuggerJobImpl(int id, JobControllerImpl controller, Process process, String line, boolean runInBackground, Session session, JobListener jobHandler) {
        this.id = id;
        this.controller = controller;
        this.process = process;
        this.line = line;
        this.session = session;
        this.terminateFuture = Future.future();
        this.runInBackground = new AtomicBoolean(runInBackground);
        this.jobHandler = jobHandler;
        if (jobHandler == null) {
            throw new IllegalArgumentException("JobListener is required");
        }
        process.terminatedHandler((Handler)new TerminatedHandler(controller));
    }

    public ExecStatus actualStatus() {
        return this.actualStatus;
    }

    public boolean interrupt() {
        return this.process.interrupt();
    }

    public Job resume() {
        return this.resume(true);
    }

    public Date timeoutDate() {
        return this.timeoutDate;
    }

    public void setTimeoutDate(Date date) {
        this.timeoutDate = date;
    }

    public Session getSession() {
        return this.session;
    }

    public Job resume(boolean foreground) {
        try {
            this.process.resume(foreground, (Handler)new ResumeHandler());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.runInBackground.set(!foreground);
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)this.process.status());
        }
        if (this.status() == ExecStatus.RUNNING) {
            if (foreground) {
                this.jobHandler.onForeground((Job)this);
            } else {
                this.jobHandler.onBackground((Job)this);
            }
        }
        return this;
    }

    public Job suspend() {
        try {
            this.process.suspend((Handler)new SuspendHandler());
        }
        catch (IllegalStateException ignore) {
            return this;
        }
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)this.process.status());
        }
        this.jobHandler.onSuspend((Job)this);
        return this;
    }

    public void terminate() {
        try {
            this.process.terminate();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public Process process() {
        return this.process;
    }

    public ExecStatus status() {
        return this.process.status();
    }

    public String line() {
        return this.line;
    }

    public boolean isRunInBackground() {
        return this.runInBackground.get();
    }

    public Job toBackground() {
        if (!this.runInBackground.get() && this.runInBackground.compareAndSet(false, true)) {
            this.process.toBackground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle((Object)this.process.status());
            }
            this.jobHandler.onBackground((Job)this);
        }
        return this;
    }

    public Job toForeground() {
        if (this.runInBackground.get() && this.runInBackground.compareAndSet(true, false)) {
            this.process.toForeground();
            if (this.statusUpdateHandler != null) {
                this.statusUpdateHandler.handle((Object)this.process.status());
            }
            this.jobHandler.onForeground((Job)this);
        }
        return this;
    }

    public int id() {
        return this.id;
    }

    public Job run() {
        return this.run(!this.runInBackground.get());
    }

    public Job run(boolean foreground) {
        this.actualStatus = ExecStatus.RUNNING;
        if (this.statusUpdateHandler != null) {
            this.statusUpdateHandler.handle((Object)ExecStatus.RUNNING);
        }
        this.process.setSession(this.session);
        this.process.run(foreground);
        if (this.status() == ExecStatus.RUNNING) {
            if (foreground) {
                this.jobHandler.onForeground((Job)this);
            } else {
                this.jobHandler.onBackground((Job)this);
            }
        }
        return this;
    }

    private class TerminatedHandler
    implements Handler<Integer> {
        private final JobControllerImpl controller;

        public TerminatedHandler(JobControllerImpl controller) {
            this.controller = controller;
        }

        public void handle(Integer exitCode) {
            DebuggerJobImpl.this.jobHandler.onTerminated((Job)DebuggerJobImpl.this);
            if (DebuggerJobImpl.this.statusUpdateHandler != null) {
                DebuggerJobImpl.this.statusUpdateHandler.handle((Object)ExecStatus.TERMINATED);
            }
            DebuggerJobImpl.this.terminateFuture.complete();
        }
    }

    private class ResumeHandler
    implements Handler<Void> {
        private ResumeHandler() {
        }

        public void handle(Void event) {
            DebuggerJobImpl.this.actualStatus = ExecStatus.RUNNING;
        }
    }

    private class SuspendHandler
    implements Handler<Void> {
        private SuspendHandler() {
        }

        public void handle(Void event) {
            DebuggerJobImpl.this.actualStatus = ExecStatus.STOPPED;
        }
    }
}

