/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.job;

import com.lubanops.apm.integration.debugger.handler.DebuggerCommandHandler;
import com.lubanops.apm.integration.debugger.service.job.ClassesJob;
import com.lubanops.apm.integration.debugger.service.job.CommandType;
import com.lubanops.apm.integration.debugger.service.job.IJob;
import com.lubanops.apm.integration.debugger.service.job.InstancesJob;
import com.lubanops.apm.integration.debugger.service.job.JadJob;
import com.lubanops.apm.integration.debugger.service.job.MethodsJob;
import com.lubanops.apm.integration.debugger.service.job.ObjectJob;
import com.lubanops.apm.integration.debugger.service.job.ResetJob;
import com.lubanops.apm.integration.debugger.service.job.StackJob;
import com.lubanops.apm.integration.debugger.service.job.ThreadsJob;
import com.lubanops.apm.integration.debugger.service.job.TraceJob;
import com.lubanops.apm.integration.debugger.service.job.WatchJob;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DebugJobFactory {
    private Map<CommandType, IJob> jobMap = new ConcurrentHashMap<CommandType, IJob>();

    public DebugJobFactory() {
        DebuggerCommandHandler debuggerCommandHandler = new DebuggerCommandHandler();
        this.registerJob(new ThreadsJob(debuggerCommandHandler));
        this.registerJob(new MethodsJob(debuggerCommandHandler));
        this.registerJob(new ClassesJob(debuggerCommandHandler));
        this.registerJob(new TraceJob(debuggerCommandHandler));
        this.registerJob(new JadJob(debuggerCommandHandler));
        this.registerJob(new InstancesJob(debuggerCommandHandler));
        this.registerJob(new ObjectJob(debuggerCommandHandler));
        this.registerJob(new StackJob(debuggerCommandHandler));
        this.registerJob(new WatchJob(debuggerCommandHandler));
        this.registerJob(new ResetJob(debuggerCommandHandler));
    }

    public IJob getJob(CommandType type) {
        return this.jobMap.get((Object)type);
    }

    public void registerJob(IJob job) {
        this.jobMap.put(job.getType(), job);
    }
}

