/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import java.util.Locale;

public class ThreadCommand
extends AbstractMessageProvider<ThreadCommand> {
    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.ThreadArguments args = (Requests.ThreadArguments)commandArguments;
        return this.toCommandLine(args);
    }

    @Override
    public Class<ThreadCommand> getType() {
        return ThreadCommand.class;
    }

    private ArthasDebuggerCommand toCommandLine(Requests.ThreadArguments args) {
        StringBuilder sb = new StringBuilder("thread");
        if (args.getId() != 0L) {
            sb.append(" " + args.getId().toString());
        }
        if (args.getTopNBusy() != 0) {
            sb.append(" -n " + args.getTopNBusy().toString());
        }
        if (StringUtils.hasText((String)args.getState())) {
            sb.append(" --state " + args.getState().toUpperCase(Locale.ROOT));
        }
        if (args.isMostBlockingThread()) {
            sb.append(" -b");
        }
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

