/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConnectConfig {
    private Long instanceId;
    private long connectTimeout = 2000L;
    private boolean randomConnect = false;
    private List<String> secureAddressList;
    private List<String> unSecureAddressList;
    private boolean isSecure = true;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectConfig)) {
            return false;
        }
        ConnectConfig that = (ConnectConfig)o;
        if (this.connectTimeout != that.connectTimeout) {
            return false;
        }
        if (this.randomConnect != that.randomConnect) {
            return false;
        }
        if (this.isSecure != that.isSecure) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.secureAddressList != null ? !this.secureAddressList.equals(that.secureAddressList) : that.secureAddressList != null) {
            return false;
        }
        return this.unSecureAddressList != null ? this.unSecureAddressList.equals(that.unSecureAddressList) : that.unSecureAddressList == null;
    }

    public int hashCode() {
        int result = this.instanceId != null ? this.instanceId.hashCode() : 0;
        result = 31 * result + (int)(this.connectTimeout ^ this.connectTimeout >>> 32);
        result = 31 * result + (this.randomConnect ? 1 : 0);
        result = 31 * result + (this.secureAddressList != null ? this.secureAddressList.hashCode() : 0);
        result = 31 * result + (this.unSecureAddressList != null ? this.unSecureAddressList.hashCode() : 0);
        result = 31 * result + (this.isSecure ? 1 : 0);
        return result;
    }

    public List<String> getAddressList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isSecure) {
            list.addAll(this.secureAddressList);
        } else {
            list.addAll(this.unSecureAddressList);
        }
        if (this.isRandomConnect()) {
            Collections.shuffle(list);
        }
        return list;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean secure) {
        this.isSecure = secure;
    }

    public List<String> getSecureAddressList() {
        return this.secureAddressList;
    }

    public void setSecureAddressList(List<String> secureAddressList) {
        this.secureAddressList = secureAddressList;
    }

    public List<String> getUnSecureAddressList() {
        return this.unSecureAddressList;
    }

    public void setUnSecureAddressList(List<String> unSecureAddressList) {
        this.unSecureAddressList = unSecureAddressList;
    }

    public boolean isRandomConnect() {
        return this.randomConnect;
    }

    public void setRandomConnect(boolean randomConnect) {
        this.randomConnect = randomConnect;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}

