/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.transport.websocket;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.integration.exception.JavaagentRuntimeException;
import com.lubanops.apm.integration.transport.websocket.ConnectConfig;
import com.lubanops.apm.integration.transport.websocket.LubanWebSocketClient;
import com.lubanops.apm.integration.transport.websocket.SecureWebSocketClient;
import com.lubanops.apm.integration.transport.websocket.UnSecureWebSocketClient;
import com.lubanops.apm.integration.utils.UriUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WebSocketFactory {
    private static final Logger LOG = LogFactory.getLogger();
    private static WebSocketFactory factory = new WebSocketFactory();
    private ConnectConfig connectConfig;
    private LubanWebSocketClient lubanWebSocketClient;
    private boolean needReconnect;
    private long lastConnectTime;

    private WebSocketFactory() {
    }

    public static WebSocketFactory getInstance() {
        return factory;
    }

    public LubanWebSocketClient getWebSocketClient(String proxy) {
        if (this.connectConfig == null) {
            throw new JavaagentRuntimeException("factory not initialized");
        }
        if (this.useCurrent()) {
            return this.lubanWebSocketClient;
        }
        return this.createWebSocketClient(proxy);
    }

    private boolean useCurrent() {
        return !this.needReconnect && this.lubanWebSocketClient != null && this.lubanWebSocketClient.isOpen();
    }

    public synchronized void setConfig(ConnectConfig newConfig) {
        if (this.connectConfig == null) {
            this.connectConfig = newConfig;
            return;
        }
        if (this.connectConfig.equals(newConfig)) {
            return;
        }
        this.connectConfig = newConfig;
        this.needReconnect = true;
    }

    private synchronized LubanWebSocketClient createWebSocketClient(String proxy) {
        if (this.useCurrent()) {
            return this.lubanWebSocketClient;
        }
        if (this.lubanWebSocketClient != null) {
            this.lubanWebSocketClient.close();
            this.lubanWebSocketClient = null;
        }
        LubanWebSocketClient client = null;
        List<String> addressList = this.connectConfig.getAddressList();
        for (String address : addressList) {
            String uri = UriUtil.buildUri(address, AgentConfigManager.getMasterAuthAk(), AgentConfigManager.getMasterAuthSk(), this.connectConfig.getInstanceId());
            URI serverUri = this.buildServerUri(uri);
            LubanWebSocketClient cc = this.connectConfig.isSecure() ? new SecureWebSocketClient(serverUri, uri) : new UnSecureWebSocketClient(serverUri, uri);
            LOG.log(Level.SEVERE, "[TRANSFER INVOKER]make client from  uri:" + uri.substring(0, 80) + " to WebSocketClient:" + (Object)((Object)cc));
            if (!StringUtils.isBlank((String)proxy)) {
                String[] hostAndPort = proxy.split(":");
                InetSocketAddress socksAddr = new InetSocketAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1]));
                Proxy proxyAddress = new Proxy(Proxy.Type.SOCKS, socksAddr);
                cc.setProxy(proxyAddress);
            }
            try {
                cc.connectBlocking(this.connectConfig.getConnectTimeout(), TimeUnit.MILLISECONDS);
                if (!cc.isOpen() || !cc.isHasOpenResult(this.connectConfig.getConnectTimeout())) continue;
                LOG.log(Level.WARNING, "cc.isOpen()");
                client = cc;
                break;
            }
            catch (InterruptedException e) {
                throw new JavaagentRuntimeException("connect InterruptedException:", e);
            }
        }
        if (client != null) {
            this.needReconnect = false;
            this.lubanWebSocketClient = client;
            this.setLastConnectTime(System.currentTimeMillis());
            client.setConnectionLostTimeout(0);
            return client;
        }
        LOG.log(Level.WARNING, "client is null");
        return null;
    }

    private URI buildServerUri(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            throw new JavaagentRuntimeException("wrong uri:" + s, e);
        }
    }

    public long getLastConnectTime() {
        return this.lastConnectTime;
    }

    public void setLastConnectTime(long lastConnectTime) {
        this.lastConnectTime = lastConnectTime;
    }
}

