/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc;

import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.qos.QoSTask;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import com.huawei.gaussdb.jdbc.util.WriterHandler;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.DriverManager;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class CollectDBData {
    private static final OperatingSystemMXBean OPERATING_SYSTEM_MXBEAN_OPERATING = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final java.util.logging.Logger PARENT_LOGGER = java.util.logging.Logger.getLogger("com.huawei.dbMonitor");
    private static final int INTERVAL = 5000;
    private static final double PERCENTAGE = 100.0;
    private static Log fileLogger = Logger.getLogger("com.huawei.dbMonitor.collect");
    private static volatile Handler handler = null;
    private static Log LOGGER = Logger.getLogger(CollectDBData.class.getName());
    private static String loggerHandlerFile;
    private static String osType;
    private static volatile boolean isInitialized;
    private static QoSTask qoSTask;
    private static AtomicLong visitCount;
    private static AtomicLong openDBCount;
    private static AtomicLong closeDBCount;
    private static AtomicLong abortDBCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void collectConnection(Properties props, int connectionTimeOut) {
        HostSpec[] cnLists;
        if (!CollectDBData.isCollectData(props)) {
            return;
        }
        if (!isInitialized) {
            Class<CollectDBData> clazz = CollectDBData.class;
            // MONITORENTER : com.huawei.gaussdb.jdbc.CollectDBData.class
            if (!isInitialized) {
                CollectDBData.initDBMonitor(props);
            }
            // MONITOREXIT : clazz
        }
        CollectDBData.increaseCount(props, CollectType.OPEN);
        HostSpec[] hostSpecArray = cnLists = CollectDBData.cnHostSpecs(props);
        int n = hostSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            HostSpec cnList = hostSpecArray[n2];
            CollectDBData.startQoSMonitor(cnList, connectionTimeOut);
            ++n2;
        }
    }

    private static void initDBMonitor(Properties props) {
        osType = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        CollectDBData.setupLoggerFromProperties(props);
        CollectDBThread collectDBThread = new CollectDBThread();
        collectDBThread.start();
        qoSTask = new QoSTask();
        isInitialized = true;
    }

    private static void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (!"debug".equals(driverLogLevel)) {
            return;
        }
        PARENT_LOGGER.setLevel(Level.FINE);
        String dbMonitorLogFile = PGProperty.LOGGER_FILE.get(props);
        if (dbMonitorLogFile != null && dbMonitorLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        if (dbMonitorLogFile != null) {
            try {
                handler = new FileHandler(dbMonitorLogFile);
                loggerHandlerFile = dbMonitorLogFile;
            }
            catch (IOException e) {
                LOGGER.error("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter dbMonitorFormatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new WriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), dbMonitorFormatter) : new StreamHandler(System.err, dbMonitorFormatter));
        } else {
            handler.setFormatter(dbMonitorFormatter);
        }
        handler.setLevel(PARENT_LOGGER.getLevel());
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static HostSpec[] cnHostSpecs(Properties props) {
        String[] ports = props.getProperty("PGPORT").split(",");
        String[] hosts = props.getProperty("PGHOST").split(",", ports.length);
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]));
        }
        return hostSpecs;
    }

    public static void increaseCount(Properties props, CollectType collectType) {
        if (!CollectDBData.isCollectData(props)) {
            return;
        }
        switch (collectType) {
            case OPEN: {
                openDBCount.incrementAndGet();
                break;
            }
            case CLOSE: {
                closeDBCount.incrementAndGet();
                break;
            }
            case ABORT: {
                abortDBCount.incrementAndGet();
                break;
            }
            case VISIT: {
                visitCount.incrementAndGet();
                break;
            }
        }
    }

    private static boolean isCollectData(Properties props) {
        return PGProperty.DB_MONITOR.getBoolean(props);
    }

    private static void startQoSMonitor(HostSpec hostSpec, int connectionTimeOut) {
        String ip = hostSpec.getHost();
        Integer port = hostSpec.getPort();
        try {
            qoSTask.monitor(ip, port, connectionTimeOut);
        }
        catch (UnknownHostException e) {
            LOGGER.error("Interrupted while sleeping: " + e);
        }
    }

    protected static String getCpuUsage() {
        int sampleCount;
        double cpuUsage = 0.0;
        for (sampleCount = 10; sampleCount > 0 && (Double.compare(cpuUsage, 0.0) == 0 || Double.compare(cpuUsage, 100.0) == 0); --sampleCount) {
            cpuUsage = CollectDBData.calculateCPUUsage();
        }
        if (sampleCount == 0 && (Double.compare(cpuUsage, 0.0) == 0 || Double.compare(cpuUsage, 100.0) == 0)) {
            cpuUsage = 0.0;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(cpuUsage);
    }

    private static double calculateCPUUsage() {
        double cpuUsage = 0.0;
        if (OPERATING_SYSTEM_MXBEAN_OPERATING != null && osType.contains("windows") || osType.contains("linux")) {
            cpuUsage = OPERATING_SYSTEM_MXBEAN_OPERATING.getSystemCpuLoad() * 100.0;
        } else {
            LOGGER.error("Unsupported operating system: " + osType);
        }
        return cpuUsage;
    }

    protected static String getMemoryUsage() {
        int sampleCount;
        double memoryUsage = 0.0;
        for (sampleCount = 10; sampleCount > 0 && (Double.compare(memoryUsage, 0.0) == 0 || Double.compare(memoryUsage, 100.0) == 0); --sampleCount) {
            memoryUsage = CollectDBData.calculateMemoryUsage();
        }
        if (sampleCount == 0 && (Double.compare(memoryUsage, 0.0) == 0 || Double.compare(memoryUsage, 100.0) == 0)) {
            LOGGER.error("Failed to retrieve memory usage!");
            memoryUsage = 0.0;
        }
        DecimalFormat df = new DecimalFormat("0.00");
        return df.format(memoryUsage);
    }

    private static double calculateMemoryUsage() {
        try {
            long totalMemory = 0L;
            long freeMemory = 0L;
            double memoryUsage = 0.0;
            if (OPERATING_SYSTEM_MXBEAN_OPERATING != null && osType.contains("windows")) {
                totalMemory = OPERATING_SYSTEM_MXBEAN_OPERATING.getTotalPhysicalMemorySize();
                freeMemory = OPERATING_SYSTEM_MXBEAN_OPERATING.getFreePhysicalMemorySize();
                if (totalMemory == 0L) {
                    return memoryUsage;
                }
                memoryUsage = (double)(totalMemory - freeMemory) / (double)totalMemory * 100.0;
            } else if (osType.contains("linux")) {
                try (InputStreamReader isr = new InputStreamReader(Files.newInputStream(Paths.get("/proc/meminfo", new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
                     BufferedReader reader = new BufferedReader(isr);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("MemTotal:")) {
                            totalMemory = CollectDBData.parseMemoryValue(line);
                        }
                        if (!line.startsWith("MemAvailable:")) continue;
                        freeMemory = CollectDBData.parseMemoryValue(line);
                    }
                }
                if (totalMemory > 0L && freeMemory > 0L) {
                    memoryUsage = (double)(totalMemory - freeMemory) / (double)totalMemory * 100.0;
                }
            } else {
                LOGGER.error("Unsupported operating system: " + osType);
            }
            return memoryUsage;
        }
        catch (IOException e) {
            LOGGER.error("File read /proc/meminfo failed, please check the file is existed or if get the permission" + e);
            return 0.0;
        }
    }

    private static long parseMemoryValue(String line) {
        String[] parts = line.split("\\s+");
        if (parts.length >= 2) {
            try {
                return Long.parseLong(parts[1]);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Parse memory failed, please check the format is right" + e);
            }
        }
        return 0L;
    }

    private static String saveCollectResult() {
        return "{" + System.lineSeparator() + "   \"openCount\": \"" + CollectDBData.getOpenCount() + "\"," + System.lineSeparator() + "   \"closeCount\": \"" + CollectDBData.getCloseCount() + "\"," + System.lineSeparator() + "   \"abortedCount\": \"" + CollectDBData.getAbortCount() + "\"," + System.lineSeparator() + "   \"visitCount\": \"" + CollectDBData.getVisitCount() + "\"," + System.lineSeparator() + "   \"cpuUsage\": \"" + CollectDBData.getCpuUsage() + "%\"," + System.lineSeparator() + "   \"memoryUsage\": \"" + CollectDBData.getMemoryUsage() + "%\"" + System.lineSeparator() + "}" + System.lineSeparator();
    }

    protected static long getVisitCount() {
        return visitCount.get();
    }

    protected static long getOpenCount() {
        return openDBCount.get();
    }

    protected static long getCloseCount() {
        return closeDBCount.get();
    }

    protected static long getAbortCount() {
        return abortDBCount.get();
    }

    static {
        osType = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        isInitialized = false;
        qoSTask = null;
        visitCount = new AtomicLong(0L);
        openDBCount = new AtomicLong(0L);
        closeDBCount = new AtomicLong(0L);
        abortDBCount = new AtomicLong(0L);
    }

    private static class CollectDBThread
    extends Thread {
        private volatile boolean isRunning = true;

        public CollectDBThread() {
            super.setName("DBMonitorThread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    qoSTask.release();
                    try {
                        handler.close();
                        handler = new FileHandler(loggerHandlerFile, true);
                        handler.setLevel(Level.ALL);
                        handler.setFormatter(new SimpleFormatter());
                        PARENT_LOGGER.addHandler(handler);
                        PARENT_LOGGER.setLevel(Level.FINE);
                        fileLogger.debug(CollectDBData.saveCollectResult());
                        handler.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("reInitFinalizeLogger failed!" + e);
                    }
                }
            });
            while (this.isRunning) {
                try {
                    TimeUnit.MILLISECONDS.sleep(5000L);
                    fileLogger.debug(CollectDBData.saveCollectResult());
                }
                catch (InterruptedException e) {
                    LOGGER.error("Interrupted while sleeping: " + e);
                }
            }
        }
    }

    public static enum CollectType {
        OPEN,
        CLOSE,
        ABORT,
        VISIT;

    }
}

