/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.core.BaseStatement;
import com.huawei.gaussdb.jdbc.core.Field;
import com.huawei.gaussdb.jdbc.core.Query;
import com.huawei.gaussdb.jdbc.core.ResultCursor;
import com.huawei.gaussdb.jdbc.core.types.PGBlob;
import com.huawei.gaussdb.jdbc.jdbc.PgResultSet;
import com.huawei.gaussdb.jdbc.mysqlcompatibility.MBooleanTypeUtils;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.List;

class MResultSet
extends PgResultSet {
    private static final String M_DATETIME = "datetime";
    private static final String M_UINT8 = "uint8";

    MResultSet(Query originalQuery, BaseStatement statement, Field[] fields, List<byte[][]> tuples, ResultCursor cursor, int maxRows, int maxFieldSize, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(originalQuery, statement, fields, tuples, cursor, maxRows, maxFieldSize, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    protected int getScale(int columnIndex) {
        Field field = this.fields[columnIndex - 1];
        if (field.getMod() == -1) {
            return -1;
        }
        return (field.getMod() - 4 & 0x7C0000) >> 18;
    }

    @Override
    protected Object getDefaultTimestamp(int columnIndex) throws SQLException {
        return M_DATETIME.equals(this.getPGType(columnIndex)) ? this.getTimestamp(columnIndex, null).toLocalDateTime() : this.getTimestamp(columnIndex, null);
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        PGBlob pgBlob = new PGBlob();
        pgBlob.setBytes(1L, this.this_row[columnIndex - 1]);
        return pgBlob;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBoolean columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return false;
        }
        int sqlType = this.getSQLType(columnIndex);
        if (sqlType != 16 && sqlType != -7) {
            Object obj = this.internalGetObject(columnIndex, this.fields[columnIndex - 1]);
            return MBooleanTypeUtils.castToBoolean(obj);
        }
        Field field = this.fields[columnIndex - 1];
        if (sqlType == -7 && field.getMod() == 1) {
            return this.this_row[columnIndex - 1].length > 0;
        }
        return MBooleanTypeUtils.castToBoolean(this.getString(this.this_row[columnIndex - 1], this.fields[columnIndex - 1]));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getBytes columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        byte[] data = this.this_row[columnIndex - 1];
        if (this.maxFieldSize > 0 && data.length > this.maxFieldSize) {
            byte[] trimData = new byte[this.maxFieldSize];
            System.arraycopy(data, 0, trimData, 0, this.maxFieldSize);
            return trimData;
        }
        return data;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getObject columnIndex: " + columnIndex);
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field == null) {
            this.wasNullFlag = true;
            return null;
        }
        if (PGBlob.BLOB_SET.contains(this.getPGType(columnIndex)) || this.getSQLType(columnIndex) == -7 && field.getMod() != 1) {
            return this.this_row[columnIndex - 1];
        }
        Object result = this.internalGetObject(columnIndex, field);
        if (result != null) {
            return result;
        }
        return this.connection.getObject(this.getPGType(columnIndex), this.getString(columnIndex), null, field);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        if (this.connection.getLogger().isTraceEnabled()) {
            this.connection.getLogger().trace("[" + this.connection.getSocketAddress() + "]   getString columnIndex: " + columnIndex);
        }
        this.checkResultSet(columnIndex);
        if (this.wasNullFlag) {
            return null;
        }
        Field field = this.fields[columnIndex - 1];
        if (field.getOID() == 700) {
            return String.valueOf(this.getFloat(columnIndex));
        }
        if (field.getOID() == 701) {
            return String.valueOf(this.getDouble(columnIndex));
        }
        return this.getString(this.this_row[columnIndex - 1], field);
    }

    @Override
    protected Number getBigInt(int columnIndex) throws SQLException {
        if (M_UINT8.equals(this.getPGType(columnIndex))) {
            return new BigInteger(this.getString(columnIndex));
        }
        return this.getLong(columnIndex);
    }
}

