/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.cluster;

import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTThreadFactory;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ALTThreadPool {
    private static final int CORE_POOL_SIZE = 8;
    private static final int MAXIMUM_POOL_SIZE = 65;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final int MAX_TASK_SIZE = 100;
    private final ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(8, 65, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ALTThreadFactory());

    private ALTThreadPool() {
    }

    public static ALTThreadPool getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public void executeTask(Runnable task) {
        this.threadPoolExecutor.execute(task);
    }

    public void closeThreadPool() {
        this.threadPoolExecutor.shutdown();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ALTThreadPool)) {
            return false;
        }
        ALTThreadPool that = (ALTThreadPool)o;
        return Objects.equals(this.threadPoolExecutor, that.threadPoolExecutor);
    }

    public int hashCode() {
        return Objects.hash(this.threadPoolExecutor);
    }

    public String toString() {
        return "ALTThreadPool{threadPoolExecutor=" + this.threadPoolExecutor + '}';
    }

    private static final class InstanceHolder {
        static final ALTThreadPool INSTANCE = new ALTThreadPool();

        private InstanceHolder() {
        }
    }
}

