/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.fan;

import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.PGProperty;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.hostchooser.HostRequirement;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.ClusterType;
import com.huawei.gaussdb.jdbc.jdbc.alt.enums.FanDBNodeStatus;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.AltClusterInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanDBNodeInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.FanTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.InitDBConnMsg;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.HostSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DBConnectionTracker {
    private static final Log LOGGER = Logger.getLogger(DBConnectionTracker.class.getName());
    private static final int FIRST = 2;
    private static final int SECOND = 1;
    private final Object releaseLock = new Object();
    private final Map<String, AltClusterInfo> clusterManager = new ConcurrentHashMap<String, AltClusterInfo>();
    private final Map<HostSpec, HostSpec> hostMap = new ConcurrentHashMap<HostSpec, HostSpec>();

    private DBConnectionTracker() {
    }

    public static DBConnectionTracker getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static boolean enableFan(Properties props) {
        return PGProperty.ENABLE_ALT.getBoolean(props);
    }

    public static boolean enableFCF(Properties props) {
        String altLevel = PGProperty.ALT_LEVEL.get(props).toUpperCase(Locale.getDefault());
        return "C".equals(altLevel) || "P".equals(altLevel);
    }

    public static boolean enableTAC(Properties props) {
        String altLevel = PGProperty.ALT_LEVEL.get(props).toUpperCase(Locale.getDefault());
        return "P".equals(altLevel);
    }

    public void initDbConnManager(InitDBConnMsg initDBConnMsg) {
        if (initDBConnMsg == null) {
            return;
        }
        AltClusterInfo altClusterInfo = this.clusterManager.get(initDBConnMsg.getAltClusterId());
        if (altClusterInfo == null) {
            altClusterInfo = new AltClusterInfo();
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = altClusterInfo.getClusterInfo();
        List<HostSpec> hostSpecs = initDBConnMsg.getHostSpecs();
        List<Integer> hostStatuses = initDBConnMsg.getHostStatuses();
        if (hostSpecs != null && hostStatuses != null && hostSpecs.size() == hostStatuses.size()) {
            for (int i = 0; i < hostSpecs.size(); ++i) {
                FanDBNodeInfo fanDBNodeInfo = cluster.getOrDefault(hostSpecs.get(i), new FanDBNodeInfo());
                fanDBNodeInfo.setDBNodeStatus(FanDBNodeStatus.of(hostStatuses.get(i)));
                cluster.put(hostSpecs.get(i), fanDBNodeInfo);
            }
        } else {
            LoggerUtil.warn(LOGGER, "Fan init Message content is incorrect.");
        }
        altClusterInfo.setClusterInfo(cluster);
        altClusterInfo.setClusterType(initDBConnMsg.getDist());
        altClusterInfo.setClusterRole(initDBConnMsg.getClusterRole());
        this.clusterManager.put(initDBConnMsg.getAltClusterId(), altClusterInfo);
        LoggerUtil.debug(LOGGER, "Fan Manager init success,initMsg is " + initDBConnMsg);
    }

    public boolean addConnectionItem(PGConnection connection, Properties props) {
        String altClusterId = props.getProperty("altClusterId");
        if (altClusterId == null || altClusterId.isEmpty()) {
            return false;
        }
        HostSpec lanHost = connection.tacGetQueryExecutor().getLanHostSpec();
        if ("*".equals(lanHost.getHost())) {
            LoggerUtil.warn(LOGGER, "Fan manager:The internal IP address is not configured.HostSpec is:" + lanHost);
            return false;
        }
        AltClusterInfo altClusterInfo = this.clusterManager.get(altClusterId);
        if (altClusterInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan manager gns not managed by the connection manager,altClusterId is " + altClusterId);
            return false;
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = altClusterInfo.getClusterInfo();
        FanDBNodeInfo dbNodeInfo = cluster.get(lanHost);
        if (dbNodeInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan addConnectionItem: hostSpec not managed by the connection manager,hostSpec is " + lanHost);
            return false;
        }
        if (DBConnectionTracker.enableTAC(props)) {
            List<PGConnection> connections = dbNodeInfo.getConnections();
            connections.add(connection);
        } else if (DBConnectionTracker.enableFCF(props)) {
            List<PGConnection> connections = dbNodeInfo.getFcfConnections();
            connections.add(connection);
        } else {
            return false;
        }
        return true;
    }

    public void nodeDown(FanTask fanMsg) {
        HostSpec hostSpec;
        LoggerUtil.debug(LOGGER, "Fan manager: FAN event node down,host is:" + fanMsg.getRemoteHost());
        AltClusterInfo altClusterInfo = this.clusterManager.get(fanMsg.getAltClusterId());
        if (altClusterInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan manager gns not managed by the connection manager,altClusterId is " + fanMsg.getAltClusterId());
            return;
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = altClusterInfo.getClusterInfo();
        FanDBNodeInfo fanDBNodeInfo = cluster.get(hostSpec = fanMsg.getRemoteHost());
        if (fanDBNodeInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan releaseConnection:hostSpec not managed by the connection manager,hostSpec is " + hostSpec);
            return;
        }
        fanDBNodeInfo.setDBNodeStatus(FanDBNodeStatus.DOWN);
        List<PGConnection> connections = fanDBNodeInfo.getFcfConnections();
        if (connections == null || connections.isEmpty()) {
            return;
        }
        for (PGConnection connection : connections) {
            connection.triggerFanCallback(fanMsg.getFanEventType());
            connection.tacGetQueryExecutor().close();
        }
        connections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFanDbConnection(QueryExecutor queryExecutor, Properties props) {
        HostSpec hostSpec = queryExecutor.getLanHostSpec();
        List<PGConnection> connections = this.getConnectionsByHost(hostSpec, props);
        if (connections == null) {
            return;
        }
        Object object = this.releaseLock;
        synchronized (object) {
            int identityQueryExecute = System.identityHashCode(queryExecutor);
            for (int i = 0; i < connections.size(); ++i) {
                if (System.identityHashCode(connections.get(i).tacGetQueryExecutor()) != identityQueryExecute) continue;
                connections.remove(i);
                LoggerUtil.debug(LOGGER, "Fan Manager, when connection close(),release Fan connection,executors is " + identityQueryExecute);
                return;
            }
        }
    }

    public void nodeUp(FanTask fanMsg) {
        AltClusterInfo altClusterInfo = this.clusterManager.get(fanMsg.getAltClusterId());
        if (altClusterInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan manager gns not managed by the connection manager,altClusterId is " + fanMsg.getAltClusterId());
            return;
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = altClusterInfo.getClusterInfo();
        HostSpec hostSpec = fanMsg.getRemoteHost();
        FanDBNodeInfo dbNodeInfo = cluster.getOrDefault(hostSpec, new FanDBNodeInfo());
        dbNodeInfo.setDBNodeStatus(fanMsg.getRole());
        cluster.put(hostSpec, dbNodeInfo);
        altClusterInfo.setClusterInfo(cluster);
        this.clusterManager.put(fanMsg.getAltClusterId(), altClusterInfo);
        LoggerUtil.debug(LOGGER, "Fan Manager, Node UP Events hosts is " + fanMsg.getRemoteHost());
    }

    private List<PGConnection> getConnectionsByHost(HostSpec hostSpec, Properties props) {
        for (Map.Entry<String, AltClusterInfo> entry : this.clusterManager.entrySet()) {
            ConcurrentHashMap<HostSpec, FanDBNodeInfo> fanConnectionManager = entry.getValue().getClusterInfo();
            if (fanConnectionManager.get(hostSpec) == null) continue;
            if (DBConnectionTracker.enableTAC(props)) {
                return ((FanDBNodeInfo)fanConnectionManager.get(hostSpec)).getConnections();
            }
            if (!DBConnectionTracker.enableFCF(props)) continue;
            return ((FanDBNodeInfo)fanConnectionManager.get(hostSpec)).getFcfConnections();
        }
        return new ArrayList<PGConnection>();
    }

    public boolean isGnsInit(String altClusterId) {
        return this.clusterManager.containsKey(altClusterId);
    }

    private FanDBNodeStatus getDBNodeStatusByHost(HostSpec param) {
        HostSpec hostSpec = this.hostMap.get(param);
        if (hostSpec == null) {
            return FanDBNodeStatus.UNKNOWN;
        }
        for (Map.Entry<String, AltClusterInfo> entry : this.clusterManager.entrySet()) {
            FanDBNodeInfo dbNodeInfo;
            ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = entry.getValue().getClusterInfo();
            if (cluster == null || (dbNodeInfo = (FanDBNodeInfo)cluster.get(hostSpec)) == null) continue;
            return dbNodeInfo.getDBNodeStatus();
        }
        return FanDBNodeStatus.UNKNOWN;
    }

    public String getAltClusterIdByHostSpec(HostSpec param) {
        HostSpec hostSpec = this.hostMap.get(param);
        if (hostSpec == null) {
            return "";
        }
        for (Map.Entry<String, AltClusterInfo> entry : this.clusterManager.entrySet()) {
            ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = entry.getValue().getClusterInfo();
            if (!cluster.containsKey(hostSpec)) continue;
            return entry.getKey();
        }
        return "";
    }

    public boolean isInTacStatus(HostSpec param) {
        HostSpec hostSpec = this.hostMap.get(param);
        if (hostSpec == null) {
            return false;
        }
        for (Map.Entry<String, AltClusterInfo> entry : this.clusterManager.entrySet()) {
            ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = entry.getValue().getClusterInfo();
            FanDBNodeInfo dbNodeInfo = (FanDBNodeInfo)cluster.get(hostSpec);
            if (dbNodeInfo == null) continue;
            return dbNodeInfo.getIsInTacStatus();
        }
        return false;
    }

    public void reportDBNodeStatus(HostSpec hostSpec, FanDBNodeStatus status) {
        HostSpec lanHostSpec = this.hostMap.get(hostSpec);
        if (lanHostSpec == null) {
            return;
        }
        for (Map.Entry<String, AltClusterInfo> entry : this.clusterManager.entrySet()) {
            ConcurrentHashMap<HostSpec, FanDBNodeInfo> cluster = entry.getValue().getClusterInfo();
            FanDBNodeInfo hostConn = (FanDBNodeInfo)cluster.get(lanHostSpec);
            if (hostConn == null) {
                LoggerUtil.warn(LOGGER, "Fan manager gns not managed by the connection manager,hostSpec is " + lanHostSpec);
                return;
            }
            hostConn.setDBNodeStatus(status);
            LoggerUtil.debug(LOGGER, "Fan manager:FCF Quick host selection DownGrade,Host is:" + lanHostSpec + ",actual status is " + (Object)((Object)status));
        }
    }

    public void recordIPMap(HostSpec hostSpec, HostSpec lanHostSpec) {
        this.hostMap.put(hostSpec, lanHostSpec);
        this.hostMap.put(lanHostSpec, lanHostSpec);
    }

    public FanDBNodeInfo getClusterMasterNode(String alterClusterId) {
        AltClusterInfo clusterInfo = this.clusterManager.get(alterClusterId);
        if (clusterInfo == null) {
            return new FanDBNodeInfo();
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> newCluster = clusterInfo.getClusterInfo();
        for (Map.Entry entry : newCluster.entrySet()) {
            FanDBNodeInfo fanDBNodeInfo = (FanDBNodeInfo)entry.getValue();
            if (fanDBNodeInfo.getDBNodeStatus() != FanDBNodeStatus.ACTIVE_MASTER) continue;
            return fanDBNodeInfo;
        }
        return new FanDBNodeInfo();
    }

    public Map<HostSpec, FanDBNodeInfo> findClusterInfo(String altClusterId) {
        AltClusterInfo clusterInfo = this.clusterManager.get(altClusterId);
        if (clusterInfo == null) {
            LoggerUtil.warn(LOGGER, "No such cluster :" + altClusterId);
            return new HashMap<HostSpec, FanDBNodeInfo>();
        }
        return clusterInfo.getClusterInfo();
    }

    public void fillRemoteHost(FanTask fanTask) {
        if (fanTask == null || fanTask.getRemoteHosts() == null || fanTask.getRemoteHosts().isEmpty()) {
            return;
        }
        List<String> tmpRemoteHosts = fanTask.getRemoteHosts();
        ArrayList<HostSpec> remoteHostSpecs = new ArrayList<HostSpec>(tmpRemoteHosts.size());
        for (String remoteHost : tmpRemoteHosts) {
            remoteHostSpecs.add(new HostSpec(remoteHost, fanTask.getPort()));
        }
        AltClusterInfo clusterInfo = this.clusterManager.get(fanTask.getAltClusterId());
        if (clusterInfo == null) {
            LoggerUtil.warn(LOGGER, "Fan Manager fillRemoteHost Error, No such cluster, AltClusterId is:" + fanTask.getAltClusterId());
            return;
        }
        ConcurrentHashMap<HostSpec, FanDBNodeInfo> clustersMap = clusterInfo.getClusterInfo();
        if (clustersMap == null) {
            fanTask.setRemoteHost((HostSpec)remoteHostSpecs.get(0));
            return;
        }
        for (HostSpec remoteHostSpec : remoteHostSpecs) {
            FanDBNodeInfo fanDBNodeInfo = clustersMap.get(remoteHostSpec);
            if (fanDBNodeInfo == null || fanDBNodeInfo.getConnections().isEmpty()) continue;
            fanTask.setRemoteHost(remoteHostSpec);
            return;
        }
        fanTask.setRemoteHost((HostSpec)remoteHostSpecs.get(0));
    }

    public boolean isAltDist(String altClusterId) {
        AltClusterInfo clusterInfo = this.clusterManager.get(altClusterId);
        if (clusterInfo == null) {
            return false;
        }
        return clusterInfo.getClusterType() == ClusterType.DISTRIBUTED;
    }

    public void cleanAltClusterInfo(String alterClusterId) {
        this.clusterManager.remove(alterClusterId);
    }

    public void sortByRequiredServerType(HostSpec[] hostSpecs, final HostRequirement target) {
        Arrays.sort(hostSpecs, new Comparator<HostSpec>(){

            @Override
            public int compare(HostSpec o1, HostSpec o2) {
                switch (target) {
                    case master: 
                    case secondary: 
                    case preferSecondary: {
                        int firstGrade = DBConnectionTracker.this.calGrade(o1, target);
                        int secondGrade = DBConnectionTracker.this.calGrade(o2, target);
                        if (firstGrade == secondGrade) {
                            return 0;
                        }
                        return firstGrade < secondGrade ? 1 : -1;
                    }
                }
                return 0;
            }
        });
    }

    private int calGrade(HostSpec hostSpec, HostRequirement target) {
        FanDBNodeStatus fanDBNodeStatus = this.getDBNodeStatusByHost(hostSpec);
        switch (fanDBNodeStatus) {
            case ACTIVE_MASTER: {
                return HostRequirement.master == target ? 2 : 1;
            }
            case ACTIVE_SECONDARY: {
                return HostRequirement.master == target ? 1 : 2;
            }
        }
        return 0;
    }

    public String toString() {
        return "DBConnectionTracker{clusterManager=" + this.clusterManager + ", hostMap=" + this.hostMap + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DBConnectionTracker)) {
            return false;
        }
        DBConnectionTracker that = (DBConnectionTracker)o;
        return Objects.equals(this.clusterManager, that.clusterManager) && Objects.equals(this.hostMap, that.hostMap);
    }

    public int hashCode() {
        return Objects.hash(this.clusterManager, this.hostMap);
    }

    private static final class InstanceHolder {
        static final DBConnectionTracker INSTANCE = new DBConnectionTracker();

        private InstanceHolder() {
        }
    }
}

