/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.mysqlcompatibility;

import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.math.BigDecimal;
import java.sql.SQLException;

public class MBooleanTypeUtils {
    private static final Log LOGGER = Logger.getLogger(MBooleanTypeUtils.class.getName());
    private static final BigDecimal BIG_DECIMAL_ZERO = BigDecimal.valueOf(0L);
    private static final BigDecimal BIG_DECIMAL_NEG_ONE = BigDecimal.valueOf(-1L);

    private MBooleanTypeUtils() {
    }

    public static boolean castToBoolean(Object in) throws SQLException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cast to boolean: \"" + String.valueOf(in) + "\"");
        }
        if (in instanceof Boolean) {
            return MBooleanTypeUtils.fromBoolean((Boolean)in);
        }
        if (in instanceof Integer) {
            return MBooleanTypeUtils.fromInt((Integer)in);
        }
        if (in instanceof Long) {
            return MBooleanTypeUtils.fromLong((Long)in);
        }
        if (in instanceof Float) {
            return MBooleanTypeUtils.fromFloat((Float)in);
        }
        if (in instanceof Double) {
            return MBooleanTypeUtils.fromDouble((Double)in);
        }
        if (in instanceof BigDecimal) {
            return MBooleanTypeUtils.fromDec((BigDecimal)in);
        }
        if (in instanceof String) {
            return MBooleanTypeUtils.fromString((String)in);
        }
        throw new PSQLException(String.format("Cannot cast to boolean: %s", in), PSQLState.CANNOT_COERCE);
    }

    private static boolean fromDec(BigDecimal in) {
        return in.compareTo(BIG_DECIMAL_ZERO) > 0 || in.compareTo(BIG_DECIMAL_NEG_ONE) == 0;
    }

    private static boolean fromDouble(Double in) {
        return in == -1.0 || in > 0.0;
    }

    private static boolean fromFloat(Float in) {
        return in.floatValue() == -1.0f || in.floatValue() > 0.0f;
    }

    private static boolean fromLong(Long in) {
        return in == -1L || in > 0L;
    }

    private static boolean fromInt(Integer in) {
        return in == -1 || in > 0;
    }

    private static boolean fromBoolean(Boolean isBoolean) {
        return isBoolean;
    }

    private static boolean fromString(String in) throws PSQLException {
        String val = in.trim();
        if (MBooleanTypeUtils.isTrueString(val)) {
            return true;
        }
        if (MBooleanTypeUtils.isFalseString(val)) {
            return false;
        }
        try {
            double doubleVal = Double.parseDouble(in);
            return doubleVal == -1.0 || doubleVal > 0.0;
        }
        catch (NumberFormatException ex) {
            throw MBooleanTypeUtils.cannotCoerceException(in, ex);
        }
    }

    private static boolean isTrueString(String val) {
        return "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val);
    }

    private static boolean isFalseString(String val) {
        return "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val);
    }

    private static PSQLException cannotCoerceException(Object value, Exception ex) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cannot cast to boolean: \"" + String.valueOf(value) + "\"");
        }
        return new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\", errorMessage: {1}", String.valueOf(value), ex.getMessage()), PSQLState.CANNOT_COERCE);
    }
}

