/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.util;

import java.util.Locale;

public class SqlConverter {
    private static final String[] KEYWORDS = new String[]{"password", "identified", "secretkey", "secret_access_key", "access_key", "pg_create_physical_replication_slot_extern", "create_credential", "gs_encrypt_aes128", "gs_decrypt_aes128", "gs_encrypt", "gs_decrypt", "aes_encrypt", "aes_decrypt", "exec_on_extension", "exec_hadoop_sql", "exec_on_extension", "dblink_connect", "gs_extend_library"};
    private static final String MASK_STR = "********";

    public static String maskSql(String nativeSql) {
        if (!SqlConverter.matchKeyword(nativeSql)) {
            return nativeSql;
        }
        return MASK_STR;
    }

    private static boolean matchKeyword(String nativeSql) {
        if (nativeSql == null) {
            return false;
        }
        String maskedSql = nativeSql.toLowerCase(Locale.US).replace("\\s+", " ");
        for (String keword : KEYWORDS) {
            if (!maskedSql.contains(keword)) continue;
            return true;
        }
        return false;
    }
}

