/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.util;

import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import com.huawei.gaussdb.jdbc.util.StreamWrapperFinalizeAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class StreamWrapper
implements Closeable {
    private static final int MAX_MEMORY_BUFFER_BYTES = 51200;
    private static final String TEMP_FILE_PREFIX = "gauss-gsjdbc-stream";
    private final InputStream stream;
    private StreamWrapperFinalizeAction finalizeAction;
    private final byte[] rawData;
    private final int offset;
    private final int length;

    public StreamWrapper(byte[] data, int offset, int length) {
        this.stream = null;
        this.rawData = data;
        this.offset = offset;
        this.length = length;
    }

    public StreamWrapper(InputStream stream, int length) {
        this.stream = stream;
        this.rawData = null;
        this.offset = 0;
        this.length = length;
    }

    public StreamWrapper(InputStream stream) throws PSQLException {
        block19: {
            try {
                ByteArrayOutputStream memoryOutputStream = new ByteArrayOutputStream();
                int memoryLength = StreamWrapper.copyStream(stream, memoryOutputStream, 51200);
                byte[] data = memoryOutputStream.toByteArray();
                if (memoryLength == -1) {
                    int diskLength;
                    Path tempFile = Files.createTempFile(TEMP_FILE_PREFIX, ".tmp", new FileAttribute[0]);
                    try (OutputStream diskOutputStream = Files.newOutputStream(tempFile, new OpenOption[0]);){
                        diskOutputStream.write(data);
                        diskLength = StreamWrapper.copyStream(stream, diskOutputStream, Integer.MAX_VALUE - data.length);
                        if (diskLength == -1) {
                            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
                        }
                    }
                    catch (PSQLException | Error | RuntimeException e) {
                        tempFile.toFile().delete();
                        throw e;
                    }
                    this.finalizeAction = new StreamWrapperFinalizeAction(tempFile);
                    this.offset = 0;
                    this.length = data.length + diskLength;
                    this.rawData = null;
                    this.stream = null;
                    break block19;
                }
                this.rawData = data;
                this.stream = null;
                this.offset = 0;
                this.length = data.length;
            }
            catch (IOException e) {
                throw new PSQLException(GT.tr("An I/O error occurred while sending to the backend.", new Object[0]), PSQLState.IO_ERROR, (Throwable)e);
            }
        }
    }

    public InputStream getStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        StreamWrapperFinalizeAction streamWrapperFinalizeAction = this.finalizeAction;
        if (streamWrapperFinalizeAction != null) {
            return streamWrapperFinalizeAction.getStream();
        }
        return new ByteArrayInputStream(this.rawData, this.offset, this.length);
    }

    @Override
    public void close() throws IOException {
        StreamWrapperFinalizeAction streamWrapperFinalizeAction = this.finalizeAction;
        if (streamWrapperFinalizeAction != null) {
            streamWrapperFinalizeAction.close();
            this.finalizeAction = null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBytes() {
        return this.rawData;
    }

    public String toString() {
        return "<stream of " + this.length + " bytes>";
    }

    private static int copyStream(InputStream inputStream, OutputStream outputStream, int limit) throws IOException {
        int totalLength = 0;
        byte[] buffer = new byte[2048];
        int readLength = inputStream.read(buffer);
        while (readLength > 0) {
            outputStream.write(buffer, 0, readLength);
            if ((totalLength += readLength) >= limit) {
                return -1;
            }
            readLength = inputStream.read(buffer);
        }
        return totalLength;
    }
}

