/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.collector.api;

import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractPrimaryKeyValueAggregator<K, V extends StatsBase>
extends AbstractAggregator {
    public static final String DEFAULT_KEY = "default_key_sys";
    private static final int[] DEFAULT_RANGES = new int[]{10, 100, 500, 1000, 10000};
    protected volatile ConcurrentMap<K, V> valueStats;
    private AtomicReference<V> defaultValueRef = new AtomicReference();
    private int[] ranges = AbstractPrimaryKeyValueAggregator.getDefaultRanges();

    public AbstractPrimaryKeyValueAggregator() {
        this(16);
    }

    public AbstractPrimaryKeyValueAggregator(int i) {
        this.valueStats = new ConcurrentHashMap(i);
    }

    @Override
    public List<MonitorDataRow> harvest() {
        if (this.valueStats.isEmpty()) {
            return null;
        }
        ArrayList<MonitorDataRow> rowList = new ArrayList<MonitorDataRow>();
        for (Map.Entry entry : this.valueStats.entrySet()) {
            Object pk = entry.getKey();
            StatsBase stats = (StatsBase)entry.getValue();
            MonitorDataRow row = null;
            if (stats instanceof DefaultSectionStats) {
                row = ((DefaultSectionStats)stats).harvest(this.ranges);
                if (((DefaultSectionStats)stats).hasExpired().booleanValue() && row == null) {
                    this.valueStats.remove(pk);
                    if (this.defaultKey().equals(pk)) {
                        this.defaultValueRef.set(null);
                    }
                }
            } else {
                row = stats.harvest();
            }
            if (row == null) continue;
            this.setPrimaryKey(row, pk);
            rowList.add(row);
        }
        return rowList;
    }

    @Override
    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        if (primaryKeyMap == null) {
            throw new ApmRuntimeException("primaryKeyMap is null");
        }
        K primaryKey = this.getPrimaryKey(primaryKeyMap);
        V value = this.obtainValue(primaryKey);
        if (value != null) {
            MonitorDataRow row = value.getStatus();
            this.setPrimaryKey(row, primaryKey);
            return row;
        }
        return null;
    }

    @Override
    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> rowList = new ArrayList<MonitorDataRow>();
        for (Map.Entry entry : this.valueStats.entrySet()) {
            Object pk = entry.getKey();
            StatsBase stats = (StatsBase)entry.getValue();
            MonitorDataRow row = stats.getStatus();
            this.setPrimaryKey(row, pk);
            rowList.add(row);
        }
        return rowList;
    }

    public abstract K getPrimaryKey(Map<String, String> var1);

    protected abstract void setPrimaryKey(MonitorDataRow var1, K var2);

    protected abstract Class<V> getValueType();

    protected abstract K defaultKey();

    protected V getValue(K key) {
        StatsBase v = (StatsBase)this.valueStats.get(key);
        if (v != null) {
            return (V)v;
        }
        if (this.valueStats.size() > this.getMaxRowCount()) {
            this.setFull(true);
        } else {
            this.setFull(false);
        }
        if (this.isFull) {
            v = (StatsBase)this.defaultValueRef.get();
            if (null == v) {
                this.defaultValueRef.compareAndSet(null, this.createValueInstance());
                v = (StatsBase)this.defaultValueRef.get();
                this.valueStats.putIfAbsent(this.defaultKey(), v);
            }
            return (V)v;
        }
        v = this.createValueInstance();
        StatsBase oldvalue = this.valueStats.putIfAbsent(key, v);
        if (oldvalue != null) {
            v = oldvalue;
        }
        return (V)v;
    }

    protected V obtainValue(K key) {
        return (V)((StatsBase)this.valueStats.get(key));
    }

    private V createValueInstance() {
        try {
            StatsBase v = (StatsBase)this.getValueType().newInstance();
            if (v instanceof DefaultSectionStats) {
                ((DefaultSectionStats)v).initRanges(this.ranges);
            }
            return (V)v;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("must have a default construct method!", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException!", e);
        }
    }

    protected void removeValue(K key) {
        this.valueStats.remove(key);
    }

    @Override
    public boolean isCollectAfterFull() {
        return false;
    }

    public int size() {
        return this.valueStats.size();
    }

    @Override
    public void clear() {
        this.setFull(false);
        this.setFullOutputted(false);
        this.valueStats.clear();
    }

    public String toString() {
        return this.getName();
    }

    public int[] getRanges() {
        return this.ranges;
    }

    public void setRanges(int[] ranges) {
        this.ranges = ranges;
    }

    public static int[] getDefaultRanges() {
        return (int[])DEFAULT_RANGES.clone();
    }
}

