/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.SinglePrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.interceptor.SQLAroundInterceptor;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSqlSectionStats;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import java.util.List;
import java.util.Map;

public class DefaultSqlStatsAggregator
extends SinglePrimaryKeyAggregator<DefaultSqlSectionStats>
implements SQLAroundInterceptor {
    private static ThreadLocal<DefaultSqlSectionStats> statsLocal = new ThreadLocal();
    private static ThreadLocal<Long> timeLocal = new ThreadLocal();

    @Override
    public String getName() {
        return "stats";
    }

    @Override
    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    @Override
    protected Class<DefaultSqlSectionStats> getValueType() {
        return DefaultSqlSectionStats.class;
    }

    @Override
    public void parseParameters(Map<String, String> parameters) {
    }

    @Override
    public String getPrimaryKey(Map<String, String> primaryKeyMap) {
        String sql = primaryKeyMap.get("sql");
        if (sql == null) {
            throw new ApmRuntimeException("tag sql is null");
        }
        return Util.getMD5String(sql);
    }

    @Override
    protected void setPrimaryKey(MonitorDataRow row, String s) {
        row.put("md5", Util.getMD5String(s));
        row.put("sql", s);
    }

    @Override
    protected String primaryKey() {
        return null;
    }

    @Override
    public long onStart(String sql) {
        if (!this.isEnable) {
            return 0L;
        }
        DefaultSqlSectionStats stats = (DefaultSqlSectionStats)this.getValue(sql);
        long start = stats.onStart();
        statsLocal.set(stats);
        timeLocal.set(start);
        return start;
    }

    @Override
    public void onThrowable(String sql, Throwable t) {
        if (!this.isEnable) {
            return;
        }
        DefaultSqlSectionStats stat = statsLocal.get();
        if (stat != null) {
            stat.onThrowable(sql, t);
            stat.setErrorTraceId(TraceCollector.getTraceId());
        }
    }

    @Override
    public long onFinally(String sql, int updatedRowCount, int readRowCount) {
        if (!this.isEnable) {
            return 0L;
        }
        DefaultSqlSectionStats stat = statsLocal.get();
        Long start = timeLocal.get();
        if (stat != null && start != null) {
            long timeInNanos = System.nanoTime() - start;
            if (stat.onFinally(sql, timeInNanos, updatedRowCount, readRowCount)) {
                stat.setSlowTraceId(TraceCollector.getTraceId());
            }
            statsLocal.set(null);
            timeLocal.set(null);
            return timeInNanos;
        }
        return 0L;
    }
}

