/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common.url;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.plugin.common.url.TokenBucket;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlSlowRequestThreshold;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlStats;
import com.lubanops.apm.bootstrap.sample.SampleConfig;
import com.lubanops.apm.bootstrap.sample.SampleType;
import com.lubanops.apm.bootstrap.sample.SamplingStrategy;
import com.lubanops.apm.bootstrap.utils.AntPathMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class UrlAggregator<T extends UrlStats>
extends MultiPrimaryKeyAggregator<T> {
    private Integer slowRequestThreshold = null;
    private Map<String, UrlSlowRequestThreshold> urlSlowRequestThresholds = new HashMap<String, UrlSlowRequestThreshold>();
    private SampleConfig sampleConfig = new SampleConfig();
    private List<String> slowUrl = new ArrayList<String>();
    private List<String> errorUrl = new ArrayList<String>();
    private AtomicInteger sampleCount = new AtomicInteger(0);
    private AtomicInteger invokeCount = new AtomicInteger(0);
    private Stats slowRequestTraceCountStats = ConfigManager.getSlowRequestTraceCountStats();
    private Stats errorRequestTraceCounStats = ConfigManager.getErrorRequestTraceCounStats();
    private Stats requestTranceCountStats = ConfigManager.getRequestTranceCountStats();
    private static AntPathMatcher matcher = new AntPathMatcher();

    public List<String> getSlowUrl() {
        return this.slowUrl;
    }

    public void setSlowUrl(List<String> slowUrl) {
        this.slowUrl = slowUrl;
    }

    public List<String> getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(List<String> errorUrl) {
        this.errorUrl = errorUrl;
    }

    @Override
    public List<MonitorDataRow> harvest() {
        this.errorRequestTraceCounStats.sampleCount.set(0);
        this.slowRequestTraceCountStats.sampleCount.set(0);
        this.requestTranceCountStats.sampleCount.set(0);
        this.sampleCount.set(0);
        this.invokeCount.set(0);
        return super.harvest();
    }

    public boolean sample(String url, String method, SampleConfig sampleConfig) {
        this.invokeCount.addAndGet(1);
        SamplingStrategy samplingStrategy = ConfigManager.getSamplingStrategy();
        if (samplingStrategy == SamplingStrategy.TAIL_BASED) {
            return TokenBucket.getInstance().consumeToken();
        }
        if (samplingStrategy == SamplingStrategy.FIXED_RATE) {
            int urlSamplingRate = ConfigManager.getGlobalSamplingRate();
            if (ThreadLocalRandom.current().nextInt(100) < urlSamplingRate) {
                return TokenBucket.getInstance().consumeToken();
            }
            return false;
        }
        String type = sampleConfig.getSampleType();
        if (type == null) {
            type = SampleType.automatic.value();
        }
        if (SampleType.automatic.value().equals(type)) {
            if (this.getErrorUrl().contains(url)) {
                return this.resolveSampleStat(url, method, this.errorRequestTraceCounStats);
            }
            if (this.getSlowUrl().contains(url)) {
                return this.resolveSampleStat(url, method, this.slowRequestTraceCountStats);
            }
            return this.resolveSampleStat(url, method, this.requestTranceCountStats);
        }
        if (SampleType.all.value().equals(type)) {
            return true;
        }
        if (SampleType.frequency.value().equals(type)) {
            return this.sampleFrequency(url, method, sampleConfig);
        }
        if (SampleType.percentage.value().equals(type)) {
            return this.samplePercentage(url, method, sampleConfig);
        }
        return false;
    }

    private boolean resolveSampleStat(String url, String method, Stats stats) {
        PrimaryKey ppk = method == null ? new PrimaryKey(url) : new PrimaryKey(url, method);
        UrlStats urlst = (UrlStats)this.obtainValue(ppk);
        if (urlst == null) {
            return false;
        }
        if (stats.sampleCount.addAndGet(1) <= stats.getThreshold()) {
            urlst.getSampleCount().addAndGet(1);
            return true;
        }
        return urlst.getSampleCount().addAndGet(1) <= stats.getMinPerUrl();
    }

    private boolean sampleFrequency(String url, String method, SampleConfig sampleConfig) {
        PrimaryKey ppk = method == null ? new PrimaryKey(url) : new PrimaryKey(url, method);
        UrlStats urlst = (UrlStats)this.obtainValue(ppk);
        AtomicInteger urlSampleCount = urlst != null ? urlst.getSampleCount() : this.sampleCount;
        int count = urlSampleCount.addAndGet(1);
        if (count < sampleConfig.getPeriodCount()) {
            return true;
        }
        urlSampleCount.decrementAndGet();
        return false;
    }

    private boolean samplePercentage(String url, String method, SampleConfig sampleConfig) {
        long invokeCount;
        AtomicInteger sampleCount;
        PrimaryKey ppk = method == null ? new PrimaryKey(url) : new PrimaryKey(url, method);
        UrlStats urlst = (UrlStats)this.obtainValue(ppk);
        if (urlst != null) {
            sampleCount = urlst.getSampleCount();
            invokeCount = urlst.getInvokeCount();
        } else {
            sampleCount = this.sampleCount;
            invokeCount = this.invokeCount.get();
        }
        int count = sampleCount.addAndGet(1);
        if (invokeCount == 0L) {
            if (sampleConfig.getPercentage() > 0) {
                return true;
            }
            sampleCount.decrementAndGet();
            return false;
        }
        if ((long)(count * 100) / invokeCount < (long)sampleConfig.getPercentage().intValue()) {
            return true;
        }
        sampleCount.decrementAndGet();
        return false;
    }

    public Stats getSlowRequestTraceCountStats() {
        return this.slowRequestTraceCountStats;
    }

    public void setSlowRequestTraceCountStats(Stats slowRequestTraceCountStats) {
        this.slowRequestTraceCountStats = slowRequestTraceCountStats == null ? ConfigManager.getSlowRequestTraceCountStats() : slowRequestTraceCountStats;
    }

    public Stats getErrorRequestTraceCounStats() {
        return this.errorRequestTraceCounStats;
    }

    public void setErrorRequestTraceCounStats(Stats errorRequestTraceCounStats) {
        this.errorRequestTraceCounStats = errorRequestTraceCounStats == null ? ConfigManager.getErrorRequestTraceCounStats() : errorRequestTraceCounStats;
    }

    public Stats getRequestTranceCountStats() {
        return this.requestTranceCountStats;
    }

    public void setRequestTranceCountStats(Stats requestTranceCountStats) {
        this.requestTranceCountStats = requestTranceCountStats == null ? ConfigManager.getRequestTranceCountStats() : requestTranceCountStats;
    }

    public SampleConfig getSampleConfig() {
        return this.sampleConfig;
    }

    public void setSampleConfig(SampleConfig sampleConfig) {
        this.sampleConfig = sampleConfig;
    }

    public void setSlowRequestThreshold(Integer slowRequestThreshold) {
        if (slowRequestThreshold == null) {
            this.slowRequestThreshold = null;
        } else {
            if (slowRequestThreshold > 20000 || slowRequestThreshold < 100) {
                slowRequestThreshold = 800;
            }
            this.slowRequestThreshold = slowRequestThreshold;
        }
    }

    public int getSlowRequestThreshold(String url) {
        UrlSlowRequestThreshold urlSlowRequestThreshold = this.urlSlowRequestThresholds.get(url);
        if (urlSlowRequestThreshold != null) {
            Integer urlSlowRequestThresholdValue = urlSlowRequestThreshold.getSlowRequestThreshold();
            if (urlSlowRequestThreshold != null) {
                return urlSlowRequestThresholdValue;
            }
        }
        if (this.slowRequestThreshold == null) {
            return ConfigManager.getSlowRequestThreshold();
        }
        return this.slowRequestThreshold;
    }

    public Map<String, UrlSlowRequestThreshold> getUrlSlowRequestThresholds() {
        return this.urlSlowRequestThresholds;
    }

    public void setUrlSlowRequestThresholds(Map<String, UrlSlowRequestThreshold> urlSlowRequestThresholds) {
        this.urlSlowRequestThresholds = urlSlowRequestThresholds;
    }

    public void setUrlSlowRequestThresholds(List<UrlSlowRequestThreshold> urlSlowRequestThresholds) {
        HashMap<String, UrlSlowRequestThreshold> urlMap = new HashMap<String, UrlSlowRequestThreshold>();
        if (urlSlowRequestThresholds != null) {
            for (int i = 0; i < urlSlowRequestThresholds.size(); ++i) {
                UrlSlowRequestThreshold urlSlowRequestThreshold = urlSlowRequestThresholds.get(i);
                urlMap.put(urlSlowRequestThreshold.getUrl(), urlSlowRequestThreshold);
            }
        }
        this.urlSlowRequestThresholds = urlMap;
    }

    public abstract String getUrlKey();

    @Override
    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected != null) {
            ArrayList<String> slowUrl = new ArrayList<String>();
            ArrayList<String> errorUrl = new ArrayList<String>();
            for (MonitorDataRow monitorDataRow : collected) {
                String url = (String)monitorDataRow.get(this.getUrlKey());
                long errorCount = (Long)monitorDataRow.get("errorCount");
                long maxTime = (Long)monitorDataRow.get("maxTime");
                int slowRequestThreshold = this.getSlowRequestThreshold(url);
                if (errorCount > 0L) {
                    errorUrl.add(url);
                    continue;
                }
                if (maxTime <= (long)slowRequestThreshold) continue;
                slowUrl.add(url);
            }
            this.setSlowUrl(slowUrl);
            this.setErrorUrl(errorUrl);
        }
        return null;
    }
}

