/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.profiler;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.LogPathUtils;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.profiler.CallStackTag;
import com.lubanops.apm.bootstrap.profiler.ClassStackTagType;
import com.lubanops.apm.bootstrap.profiler.NativeAgentBridge;
import com.lubanops.apm.bootstrap.profiler.ProfilerReportService;
import com.lubanops.apm.bootstrap.utils.StemmingPolicyUtil;
import com.lubanops.apm.bootstrap.utils.StringUtils;

public class ProfilerService {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static final ProfilerService INSTANCE = new ProfilerService();
    private NativeAgentBridge nativeAgent;
    private boolean isProfilerInitSuccess = true;
    private String sessionId;
    private boolean enabled;
    private boolean wallEnable;
    private boolean traceEnable = true;
    private ProfilerReportService reportService;
    private ThreadLocal<String> txTagLocal = new ThreadLocal();

    public static ProfilerService getInstance() {
        return INSTANCE;
    }

    public void init(String agentPath) {
        this.nativeAgent = NativeAgentBridge.getInstance(agentPath);
    }

    public void setProfilerInitSuccess(boolean isProfilerInitSuccess) {
        this.isProfilerInitSuccess = isProfilerInitSuccess;
    }

    public void setReportService(ProfilerReportService reportService) {
        this.reportService = reportService;
    }

    public void setTraceEnable(boolean traceEnable) {
        this.traceEnable = traceEnable;
    }

    public void setWallEnable(boolean wallEnable) {
        this.wallEnable = wallEnable;
    }

    public static String getWorkPath() {
        return LogPathUtils.getLogPath();
    }

    public void setSessionInfo(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setTxTag(String txTag) {
        this.txTagLocal.set(txTag);
    }

    public String getTxTag() {
        return this.txTagLocal.get();
    }

    public void sessionControl(byte[] request) {
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return;
        }
        try {
            this.nativeAgent.sessionControl(request);
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.SEVERE, "Failed to send session control request", e);
        }
    }

    public int getThreadID() {
        int tid = 0;
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return tid;
        }
        try {
            tid = this.nativeAgent.getThreadID();
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.SEVERE, "Failed to send get thread id request", e);
        }
        return tid;
    }

    public void sendControlResponse(String controlType, byte[] buffer) {
        if (controlType.equals("ProfilingSessionStarted")) {
            this.enabled = true;
        } else if (controlType.equals("ProfilingSessionStopped")) {
            this.enabled = false;
        }
    }

    public void sendProfileData(String dataType, byte[] buffer) {
        this.reportService.offerData(this.sessionId, dataType, buffer);
    }

    public void generateTxTag(String url, String method) {
        String txTag = StemmingPolicyUtil.buildTxType(method, url);
        if (StemmingPolicyUtil.isTxTypeValid(txTag)) {
            ProfilerService.getInstance().addCallstackTag(ClassStackTagType.API, txTag);
        }
    }

    public void addCallstackTag(ClassStackTagType type, String tag) {
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return;
        }
        if (this.enabled && this.traceEnable && !StringUtils.isBlank(tag)) {
            this.txTagLocal.set(tag);
            CallStackTag callStackTag = new CallStackTag(type, tag);
            try {
                this.nativeAgent.sendCallstackTag(callStackTag);
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.log(Level.SEVERE, "Failed to add call stack tag - " + callStackTag, e);
            }
        }
    }

    public void removeCallstackTag(ClassStackTagType type) {
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return;
        }
        String tag = this.txTagLocal.get();
        if (this.enabled && this.traceEnable && !StringUtils.isBlank(tag)) {
            CallStackTag callStackTag = new CallStackTag(type, tag);
            try {
                this.nativeAgent.removeCallstackTag(callStackTag);
            }
            catch (UnsatisfiedLinkError e) {
                LOGGER.log(Level.SEVERE, "Failed to remove call stack tag - " + callStackTag, e);
            }
        }
    }

    public void addThread() {
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return;
        }
        try {
            if (this.enabled && this.wallEnable) {
                this.nativeAgent.filterThread0(Thread.currentThread(), true);
            }
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.SEVERE, "Failed to add thread - " + Thread.currentThread().getName() + " to filter", e);
        }
    }

    public void removeThread() {
        if (this.nativeAgent == null || !this.isProfilerInitSuccess) {
            return;
        }
        try {
            if (this.enabled && this.wallEnable) {
                this.nativeAgent.filterThread0(Thread.currentThread(), false);
            }
        }
        catch (UnsatisfiedLinkError e) {
            LOGGER.log(Level.SEVERE, "Failed to remove thread - " + Thread.currentThread().getName() + " to filter", e);
        }
    }
}

