/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.utils.InputSafetyChecker;
import com.lubanops.apm.bootstrap.utils.LogForgingUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FileUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeFile(String filePath, String content) {
        OutputStreamWriter writer = null;
        String safePath = InputSafetyChecker.getSafePath(filePath);
        try {
            boolean result;
            File file = new File(safePath);
            if (!file.getParentFile().exists() && !(result = file.getParentFile().mkdirs())) {
                boolean bl = false;
                return bl;
            }
            if (!file.exists() && !(result = file.createNewFile())) {
                boolean bl = false;
                return bl;
            }
            writer = new FileWriter(safePath);
            writer.write(content);
            return true;
        }
        catch (IOException e) {
            LogFactory.getLogger().log(Level.SEVERE, LogForgingUtil.replace(filePath) + "\u6587\u4ef6\u5199\u5165\u5931\u8d25", e);
            return true;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String filePath) {
        StringBuilder content = new StringBuilder();
        InputStreamReader reader = null;
        int c = 0;
        try {
            String safePath = InputSafetyChecker.getSafePath(filePath);
            reader = new FileReader(safePath);
            c = reader.read();
            while (c != -1) {
                content.append((char)c);
                c = reader.read();
            }
        }
        catch (FileNotFoundException e) {
            LogFactory.getLogger().log(Level.INFO, LogForgingUtil.replace(filePath) + "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        catch (IOException e) {
            LogFactory.getLogger().log(Level.SEVERE, LogForgingUtil.replace(filePath) + "\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readFilePropertyByPath(String filePath) {
        String safePath = InputSafetyChecker.getSafePath(filePath);
        Properties properties = new Properties();
        FileInputStream fileIs = null;
        try {
            File file = new File(safePath);
            if (file.exists()) {
                fileIs = new FileInputStream(safePath);
                properties.load(fileIs);
                Properties properties2 = properties;
                return properties2;
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.WARNING, filePath + "\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff01");
        }
        finally {
            if (fileIs != null) {
                try {
                    fileIs.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public static File getInterceptorFile(ClassLoader classLoader, String interceptorName) throws ClassNotFoundException {
        ProtectionDomain pd = classLoader.loadClass(interceptorName).getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        String jarPath = cs.getLocation().getPath();
        return new File(jarPath);
    }

    public static List<URL> getLibUrl(String path) {
        ArrayList<URL> jarURLList = new ArrayList<URL>();
        try {
            File libDir = new File(path);
            File[] libFiles = libDir.listFiles();
            if (libFiles != null) {
                for (File file : libFiles) {
                    jarURLList.add(file.toURI().toURL());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jarURLList;
    }
}

