/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.common.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.plugin.rabbitmq.RabbitConnectionCounter;
import java.util.concurrent.atomic.AtomicLong;

public class RabbitMqConnectionCountStats
implements StatsBase {
    protected volatile long connectionCreatedOld;
    protected volatile long connectionClosedOld;
    protected volatile long channelCreatedOld;
    protected volatile long channelClosedOld;
    protected final AtomicLong connectionCreated = new AtomicLong();
    protected final AtomicLong connectionClosed = new AtomicLong();
    protected final AtomicLong channelCreated = new AtomicLong();
    protected final AtomicLong channelClosed = new AtomicLong();
    private String connection;

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public void incrementConnectionCreatedCount(int count) {
        this.connectionCreated.addAndGet(count);
    }

    public void incrementConnectionClosedCount(int count) {
        this.connectionClosed.addAndGet(count);
    }

    public void incrementChannelCreatedCount(int count) {
        this.channelCreated.addAndGet(count);
    }

    public void incrementChannelClosedCount(int count) {
        this.channelClosed.addAndGet(count);
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        if (this.connection == null) {
            this.connection = "unknown";
        }
        row.put((Object)"connectionCount", (Object)RabbitConnectionCounter.getConnectionCount(this.connection));
        row.put((Object)"channelCount", (Object)RabbitConnectionCounter.getChannelCount(this.connection));
        row.put((Object)"connectionCreated", (Object)this.connectionCreated.get());
        row.put((Object)"connectionClosed", (Object)this.connectionClosed.get());
        row.put((Object)"channelCreated", (Object)this.channelCreated.get());
        row.put((Object)"channelClosed", (Object)this.channelClosed.get());
        return row;
    }

    public MonitorDataRow harvest() {
        long connectionCreatedNew = this.connectionCreated.get();
        long connectionClosedNew = this.connectionClosed.get();
        long channelCreatedNew = this.channelCreated.get();
        long channelClosedNew = this.channelClosed.get();
        MonitorDataRow row = new MonitorDataRow();
        if (this.connection == null) {
            this.connection = "unknown";
        }
        row.put((Object)"connectionCount", (Object)RabbitConnectionCounter.getConnectionCount(this.connection));
        row.put((Object)"channelCount", (Object)RabbitConnectionCounter.getChannelCount(this.connection));
        row.put((Object)"connectionCreated", (Object)(connectionCreatedNew - this.connectionCreatedOld));
        row.put((Object)"connectionClosed", (Object)(connectionClosedNew - this.connectionClosedOld));
        row.put((Object)"channelCreated", (Object)(channelCreatedNew - this.channelCreatedOld));
        row.put((Object)"channelClosed", (Object)(channelClosedNew - this.channelClosedOld));
        this.connectionCreatedOld = connectionCreatedNew;
        this.connectionClosedOld = connectionClosedNew;
        this.channelCreatedOld = channelCreatedNew;
        this.channelClosedOld = channelClosedNew;
        return row;
    }
}

