/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq.producer.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.plugin.rabbitmq.RabbitMqUtils;
import com.lubanops.apm.plugin.rabbitmq.common.collector.RabbitMqConnectionInvokeAggregator;
import com.lubanops.apm.plugin.rabbitmq.producer.stats.RabbitMqPublishInvokeStats;

public class RabbitMqConnectionPublishInvokeAggregator
extends RabbitMqConnectionInvokeAggregator<RabbitMqPublishInvokeStats> {
    public void setMaxSingleMsgBytes(int bytesCount) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = (RabbitMqPublishInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.setMaxSingleMsgBytes(bytesCount);
        }
    }

    public void incrementPublishedBytesCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RabbitMqPublishInvokeStats stats = (RabbitMqPublishInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedBytesCount(count);
        }
    }

    public void incrementPublishedMsgCount() {
        RabbitMqPublishInvokeStats stats = (RabbitMqPublishInvokeStats)((Object)this.statsLocal.get());
        Long startTime = (Long)this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPublishedMsgCount();
        }
    }

    @Override
    protected void doExtraCollectAfterHarvest(MonitorDataRow row, MonitorDataRow totalRow) {
        RabbitMqUtils.accumulateCount(row, "publishedMsgCount", totalRow);
        RabbitMqUtils.accumulateCount(row, "publishedBytes", totalRow);
        RabbitMqUtils.setMax(row, "maxSingleMsgBytes", totalRow);
    }

    @Override
    protected Class<RabbitMqPublishInvokeStats> getValueType() {
        return RabbitMqPublishInvokeStats.class;
    }

    @Override
    public String getName() {
        return "connectionPublish";
    }
}

