/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.module;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Java9Module {
    public static void loadJava9Module(Instrumentation instrumentation) {
        Module targetModule = Java9Module.class.getModule();
        Module srcModule = Object.class.getModule();
        Java9Module.loadJava9Module(instrumentation, srcModule, targetModule);
    }

    public static void loadJava9Module(Instrumentation instrumentation, Module srcModule, Module targetModule) {
        LogFactory.getLogger().log(Level.SEVERE, "srcModule: " + srcModule.getName() + srcModule.getPackages() + " targetModule: " + targetModule.getName() + targetModule.getPackages());
        Java9Module.addOpens(instrumentation, targetModule, srcModule, "java.net");
        Java9Module.addOpens(instrumentation, targetModule, srcModule, "java.nio");
        Java9Module.addOpens(instrumentation, targetModule, srcModule, "sun.net.www");
        Java9Module.addExports(instrumentation, targetModule, srcModule, "jdk.internal.loader");
        Java9Module.addExports(instrumentation, targetModule, srcModule, "jdk.internal.misc");
        Java9Module.addExports(instrumentation, targetModule, srcModule, "jdk.internal.module");
    }

    private static void addOpens(Instrumentation instrumentation, Module targetModule, Module srcModule, String packageName) {
        Map<String, Set<Module>> extraOpens = Map.of(packageName, Set.of(targetModule));
        Set<Module> extraReads = Set.of();
        Map<String, Set<Module>> extraExports = Map.of();
        Set<Class<?>> extraUses = Set.of();
        Map<Class<?>, List<Class<?>>> extraProvides = Map.of();
        instrumentation.redefineModule(srcModule, extraReads, extraExports, extraOpens, extraUses, extraProvides);
    }

    private static void addExports(Instrumentation instrumentation, Module targetModule, Module srcModule, String packageName) {
        Map<String, Set<Module>> extraOpens = Map.of();
        Set<Module> extraReads = Set.of();
        Map<String, Set<Module>> extraExports = Map.of(packageName, Set.of(targetModule));
        Set<Class<?>> extraUses = Set.of();
        Map<Class<?>, List<Class<?>>> extraProvides = Map.of();
        instrumentation.redefineModule(srcModule, extraReads, extraExports, extraOpens, extraUses, extraProvides);
    }
}

