/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.collector;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.ClientObjectHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.client.RestClient;

public class EsClientInfoAggregator
extends AbstractAggregator {
    private String restClientVersion;
    private String restHighLevelClientVersion;
    private boolean isRestClientHighThanOrEqual63 = true;
    private boolean isRestClientHighThanOrEqual64 = true;
    private boolean isRestClientHighThanOrEqual70 = true;
    private static final String REST_CLIENT_VERSION_63 = "elasticsearch-rest-client-6.3.0.jar";
    private static final String REST_CLIENT_VERSION_64 = "elasticsearch-rest-client-6.4.0.jar";
    private static final String REST_CLIENT_VERSION_70 = "elasticsearch-rest-client-7.0.0.jar";

    public void parseParameters(Map<String, String> parameters) {
    }

    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    private MonitorDataRow buildRow(RestClient client) {
        Integer id = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)client, (String)"clientId");
        if (id == null) {
            return null;
        }
        String nodes = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)client, (String)"esNodes");
        String clientId = String.valueOf(id);
        String deadNodes = ClientObjectHolder.getDeadNodes(client);
        Integer poolId = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)((AttributeAccess)((AttributeAccess)client).getLopsFileds()[1]).getLopsFileds()[0], (String)"poolId");
        MonitorDataRow row = new MonitorDataRow();
        row.add("clientId", (Object)clientId);
        row.add("poolId", (Object)(poolId == null ? "unknown" : String.valueOf(poolId)));
        row.add("esNodes", (Object)nodes);
        row.add("esDeadNodes", (Object)deadNodes);
        row.add("RestHighLevelClientVersion", (Object)this.restHighLevelClientVersion);
        row.add("RestClientVersion", (Object)this.restClientVersion);
        return row;
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String clientId = primaryKeyMap.get("clientId");
        if (clientId != null) {
            CopyOnWriteArrayList<RestClient> clientList = ClientObjectHolder.getClientList();
            for (RestClient client : clientList) {
                MonitorDataRow row = this.buildRow(client);
                if (row == null || !clientId.equals(row.get((Object)"clientId"))) continue;
                return row;
            }
        }
        return null;
    }

    public void clear() {
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> res = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList<RestClient> clientList = ClientObjectHolder.getClientList();
        for (RestClient client : clientList) {
            MonitorDataRow row = this.buildRow(client);
            if (row == null) continue;
            res.add(row);
        }
        return res;
    }

    public String getRestClientVersion() {
        return this.restClientVersion;
    }

    public void setRestClientVersion(String restClientVersion) {
        if (restClientVersion.isEmpty()) {
            return;
        }
        this.restClientVersion = restClientVersion;
        this.isRestClientHighThanOrEqual63 = restClientVersion.compareTo(REST_CLIENT_VERSION_63) >= 0;
        this.isRestClientHighThanOrEqual64 = restClientVersion.compareTo(REST_CLIENT_VERSION_64) >= 0;
        this.isRestClientHighThanOrEqual70 = restClientVersion.compareTo(REST_CLIENT_VERSION_70) >= 0;
    }

    public String getRestHighLevelClientVersion() {
        return this.restHighLevelClientVersion;
    }

    public void setRestHighLevelClientVersion(String restHighLevelClientVersion) {
        this.restHighLevelClientVersion = restHighLevelClientVersion;
    }

    public boolean isRestClientHighThanOrEqual63() {
        return this.isRestClientHighThanOrEqual63;
    }

    public boolean isRestClientHighThanOrEqual64() {
        return this.isRestClientHighThanOrEqual64;
    }

    public boolean isRestClientHighThanOrEqual70() {
        return this.isRestClientHighThanOrEqual70;
    }

    public String getName() {
        return "clientInfo";
    }
}

