/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.shade.com.cloud.sdk.http.conn.ssl;

import com.huawei.shade.com.cloud.sdk.http.conn.SdkSSLSocket;
import com.huawei.shade.com.cloud.sdk.http.conn.SdkSocket;
import com.huawei.shade.com.cloud.sdk.http.conn.ssl.TLSProtocol;
import com.huawei.shade.org.apache.commons.logging.Log;
import com.huawei.shade.org.apache.commons.logging.LogFactory;
import com.huawei.shade.org.apache.http.annotation.ThreadSafe;
import com.huawei.shade.org.apache.http.conn.ConnectTimeoutException;
import com.huawei.shade.org.apache.http.conn.ssl.SSLSocketFactory;
import com.huawei.shade.org.apache.http.conn.ssl.X509HostnameVerifier;
import com.huawei.shade.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

@ThreadSafe
public class TLSSocketFactory
extends SSLSocketFactory {
    private static final Log log = LogFactory.getLog(TLSSocketFactory.class);

    public TLSSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void prepareSocket(SSLSocket socket) {
        Object[] supported = socket.getSupportedProtocols();
        Object[] enabled = socket.getEnabledProtocols();
        if (log.isDebugEnabled()) {
            log.debug("socket.getSupportedProtocols(): " + Arrays.toString(supported) + ", socket.getEnabledProtocols(): " + Arrays.toString(enabled));
        }
        ArrayList<Object> target = new ArrayList<Object>();
        if (supported != null) {
            void var8_13;
            TLSProtocol[] tLSProtocolArray;
            TLSProtocol[] tLSProtocolArray2 = tLSProtocolArray = TLSProtocol.values();
            int n = tLSProtocolArray2.length;
            boolean bl = false;
            while (var8_13 < n) {
                TLSProtocol tslprotocol = tLSProtocolArray2[var8_13];
                String pname = tslprotocol.getProtocolName();
                if (this.existsIn(pname, (String[])supported)) {
                    target.add(pname);
                }
                ++var8_13;
            }
        }
        if (enabled != null) {
            for (Object object : enabled) {
                if (target.contains(object)) continue;
                target.add(object);
            }
        }
        if (target.size() > 0) {
            Object[] objectArray = target.toArray(new String[target.size()]);
            socket.setEnabledProtocols((String[])objectArray);
            if (log.isDebugEnabled()) {
                log.debug("TLS protocol enabled for SSL handshake: " + Arrays.toString(objectArray));
            }
        }
    }

    private boolean existsIn(String element, String[] a) {
        for (String s : a) {
            if (!element.equals(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, ConnectTimeoutException {
        if (log.isDebugEnabled()) {
            log.debug("connecting to " + remoteAddress.getAddress() + ":" + remoteAddress.getPort());
        }
        this.verifyMasterSecret(super.connectSocket(socket, remoteAddress, localAddress, params));
        if (socket instanceof SSLSocket) {
            return new SdkSSLSocket((SSLSocket)socket);
        }
        return new SdkSocket(socket);
    }

    private void verifyMasterSecret(Socket sock) {
        String className;
        SSLSocket ssl;
        SSLSession session;
        if (sock instanceof SSLSocket && (session = (ssl = (SSLSocket)sock).getSession()) != null && "sun.security.ssl.SSLSessionImpl".equals(className = session.getClass().getName())) {
            try {
                Class<?> clazz = Class.forName(className);
                Method method = clazz.getDeclaredMethod("getMasterSecret", new Class[0]);
                method.setAccessible(true);
                Object masterSecret = method.invoke((Object)session, new Object[0]);
                if (masterSecret == null) {
                    throw this.log(new SecurityException("Invalid SSL master secret"));
                }
            }
            catch (ClassNotFoundException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (NoSuchMethodException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (IllegalAccessException e) {
                this.failedToVerifyMasterSecret(e);
            }
            catch (InvocationTargetException e) {
                this.failedToVerifyMasterSecret(e.getCause());
            }
        }
    }

    private void failedToVerifyMasterSecret(Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug("Failed to verify the SSL master secret", t);
        }
    }

    private <T extends Throwable> T log(T t) {
        if (log.isDebugEnabled()) {
            log.debug("", t);
        }
        return t;
    }
}

