/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.AbstractPrimaryKeyValueAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.exception.ApmRuntimeException;
import com.lubanops.apm.plugin.dubbo.collector.DubboResultCodeStats;
import java.util.List;
import java.util.Map;

public class DubboResultCodeAggregator
extends AbstractPrimaryKeyValueAggregator<String, DubboResultCodeStats> {
    private static final String DUBBO_AGGREGATE_KEY_RESULT_CODE = "code";
    private static final String DUBBO_MODEL_NAME = "resultCode";

    protected void setPrimaryKey(MonitorDataRow row, String s) {
        row.put((Object)DUBBO_AGGREGATE_KEY_RESULT_CODE, (Object)s);
    }

    protected Class<DubboResultCodeStats> getValueType() {
        return DubboResultCodeStats.class;
    }

    protected String defaultKey() {
        return "default_key_sys";
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public String getName() {
        return DUBBO_MODEL_NAME;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void onFinally(String method, String code) {
        DubboResultCodeStats codeStats = (DubboResultCodeStats)this.getValue(code);
        codeStats.onFinally(method);
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        MonitorDataRow result = null;
        String code = primaryKeyMap.get(DUBBO_AGGREGATE_KEY_RESULT_CODE);
        if (code == null) {
            throw new ApmRuntimeException("get status by primary key,but code is null");
        }
        DubboResultCodeStats codeStats = (DubboResultCodeStats)this.getValue(code);
        if (null != codeStats) {
            result = codeStats.getStatus();
            result.put((Object)DUBBO_AGGREGATE_KEY_RESULT_CODE, (Object)code);
        }
        return result;
    }

    public String getPrimaryKey(Map<String, String> primaryKeyMap) {
        String code = primaryKeyMap.get(DUBBO_AGGREGATE_KEY_RESULT_CODE);
        if (code == null) {
            throw new ApmRuntimeException("tag code is null");
        }
        return code;
    }
}

