/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.oracle;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.plugin.oracle.collector.OracleCollector;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleStatement;

public class OracleUtils {
    public static Integer getConnectionId(OracleStatement statement) throws SQLException {
        Connection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)((TransformAccess)connection).getLopsAttribute();
        }
        return null;
    }

    public static void onStatementStart(String sql, Integer connectionId) {
        try {
            ConnectionStats connectionStats;
            if (connectionId != null && (connectionStats = OracleCollector.onConnectionStart(connectionId, sql)) != null) {
                OracleCollector.onStart(sql, connectionId);
            }
        }
        catch (Exception statementOnStartException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)statementOnStartException);
        }
    }

    public static void onStatementError(String sql, Throwable e) {
        try {
            OracleCollector.onConnectionException(e, sql);
            OracleCollector.onThrowable(e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static void onStatementFinally(String sql, int updatedRowCount, int readRowCount) {
        try {
            OracleCollector.onConnectionEnd(sql, updatedRowCount, readRowCount);
            OracleCollector.onFinally(updatedRowCount, readRowCount);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    public static SqlKind getSqlKind(String sql) {
        String trimmedSql = sql.trim();
        if (trimmedSql.length() > 6) {
            String judgePart = trimmedSql.substring(0, 6);
            if ("select".equalsIgnoreCase(judgePart)) {
                return SqlKind.READ;
            }
            if ("insert".equalsIgnoreCase(judgePart) || "update".equalsIgnoreCase(judgePart)) {
                return SqlKind.UPSERT;
            }
        }
        return SqlKind.OTHERS;
    }

    public static int getRowCount(OracleStatement statement) {
        if (statement instanceof AttributeAccess) {
            Number validRows = (Number)((AttributeAccess)statement).getLopsFileds()[2];
            return validRows.intValue();
        }
        return 0;
    }

    public static enum SqlKind {
        READ,
        UPSERT,
        OTHERS;

    }
}

