/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.oracle.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.oracle.collector.OracleCollector;
import java.security.ProtectionDomain;
import oracle.jdbc.OracleConnection;

public class ConnectionConsInterceptor
implements Interceptor {
    public ConnectionConsInterceptor() {
        try {
            OracleCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)OracleConnection.class.getProtectionDomain()));
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "Unknown Oracle version", (Throwable)e);
            OracleCollector.setDriverVersion("Unknown");
        }
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            String dbName = "unknown";
            if (object instanceof AttributeAccess) {
                dbName = (String)((AttributeAccess)object).getLopsFileds()[0];
            }
            Integer id = Helper.CONNECTION_TARGET_MAP.registerResource(dbName);
            if (object instanceof TransformAccess) {
                ((TransformAccess)object).setLopsAttribute((Object)id);
            }
            OracleCollector.onConnectionCreated(id);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

