/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.coapcalifornium.client.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.coapcalifornium.CoapUtils;
import com.lubanops.apm.plugin.coapcalifornium.client.collector.CoapClientCollector;
import com.lubanops.apm.plugin.coapcalifornium.stats.CoapStats;
import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;

public class RequestSendFailedInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (CoapClientCollector.INSTANCE.isEnable() && object instanceof Request) {
                Request request = (Request)object;
                if (request.getType() == CoAP.Type.NON) {
                    return;
                }
                SpanEvent spanEvent = (SpanEvent)CoapUtils.getFromLopsAttribute(object, "spanEvent");
                Map collectorContext = (Map)CoapUtils.getFromLopsAttribute(object, "clientCollectorContext");
                CoapStats stats = (CoapStats)((Object)collectorContext.get("statsBase"));
                Long startTime = (Long)collectorContext.get("startTime");
                String statusInfo = "";
                boolean isSendError = false;
                String envId = "unknown";
                if ("sendError".equals(methodName)) {
                    isSendError = true;
                } else if ("setTimedOut".equals(methodName)) {
                    statusInfo = "ClientRequestTimeOut";
                } else if ("setCanceled".equals(methodName)) {
                    statusInfo = "ClientRequestCanceled";
                } else if ("setRejected".equals(methodName)) {
                    statusInfo = "ClientRequestRejected";
                    Response response = ((Request)object).getResponse();
                    if (response != null) {
                        OptionSet optionSet = response.getOptions();
                        List arbitraryOptions = optionSet.getOthers();
                        for (Option option : arbitraryOptions) {
                            if (option.getNumber() != 1001) continue;
                            envId = option.getStringValue();
                        }
                    }
                }
                if (isSendError && args[0] instanceof Throwable) {
                    statusInfo = "SendError: " + ((Throwable)args[0]).getMessage();
                }
                String traceId = spanEvent == null ? null : spanEvent.getTraceId();
                CoapClientCollector.conRequestOnResponseClose(false, stats, startTime, envId, traceId);
                CoapClientCollector.onStatusInfo(false, statusInfo, request.getURI(), stats, traceId);
                if (spanEvent != null) {
                    spanEvent.setSpanError(true);
                    spanEvent.addTag("statusInfo", statusInfo);
                    TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

