/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.AdviceListenerManager;
import com.taobao.arthas.core.advisor.InvokeTraceable;
import com.taobao.arthas.core.shell.system.ExecStatus;
import com.taobao.arthas.core.shell.system.ProcessAware;
import com.taobao.arthas.core.util.StringUtils;
import java.arthas.SpyAPI;
import java.util.List;

public class SpyImpl
extends SpyAPI.AbstractSpy {
    private static final Logger logger = LoggerFactory.getLogger(SpyImpl.class);

    public void atEnter(Class<?> clazz, String methodInfo, Object target, Object[] args) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitMethodInfo(methodInfo);
        String methodName = info[0];
        String methodDesc = info[1];
        List<AdviceListener> listeners = AdviceListenerManager.queryAdviceListeners(classLoader, clazz.getName(), methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    adviceListener.before(clazz, methodName, methodDesc, target, args);
                }
                catch (Throwable e) {
                    logger.error("class: {}, methodInfo: {}", new Object[]{clazz.getName(), methodInfo, e});
                }
            }
        }
    }

    public void atExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Object returnObject) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitMethodInfo(methodInfo);
        String methodName = info[0];
        String methodDesc = info[1];
        List<AdviceListener> listeners = AdviceListenerManager.queryAdviceListeners(classLoader, clazz.getName(), methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    adviceListener.afterReturning(clazz, methodName, methodDesc, target, args, returnObject);
                }
                catch (Throwable e) {
                    logger.error("class: {}, methodInfo: {}", new Object[]{clazz.getName(), methodInfo, e});
                }
            }
        }
    }

    public void atExceptionExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Throwable throwable) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitMethodInfo(methodInfo);
        String methodName = info[0];
        String methodDesc = info[1];
        List<AdviceListener> listeners = AdviceListenerManager.queryAdviceListeners(classLoader, clazz.getName(), methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    adviceListener.afterThrowing(clazz, methodName, methodDesc, target, args, throwable);
                }
                catch (Throwable e) {
                    logger.error("class: {}, methodInfo: {}", new Object[]{clazz.getName(), methodInfo, e});
                }
            }
        }
    }

    public void atBeforeInvoke(Class<?> clazz, String invokeInfo, Object target) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitInvokeInfo(invokeInfo);
        String owner = info[0];
        String methodName = info[1];
        String methodDesc = info[2];
        List<AdviceListener> listeners = AdviceListenerManager.queryTraceAdviceListeners(classLoader, clazz.getName(), owner, methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    InvokeTraceable listener = (InvokeTraceable)((Object)adviceListener);
                    listener.invokeBeforeTracing(classLoader, owner, methodName, methodDesc, Integer.parseInt(info[3]));
                }
                catch (Throwable e) {
                    logger.error("class: {}, invokeInfo: {}", new Object[]{clazz.getName(), invokeInfo, e});
                }
            }
        }
    }

    public void atAfterInvoke(Class<?> clazz, String invokeInfo, Object target) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitInvokeInfo(invokeInfo);
        String owner = info[0];
        String methodName = info[1];
        String methodDesc = info[2];
        List<AdviceListener> listeners = AdviceListenerManager.queryTraceAdviceListeners(classLoader, clazz.getName(), owner, methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    InvokeTraceable listener = (InvokeTraceable)((Object)adviceListener);
                    listener.invokeAfterTracing(classLoader, owner, methodName, methodDesc, Integer.parseInt(info[3]));
                }
                catch (Throwable e) {
                    logger.error("class: {}, invokeInfo: {}", new Object[]{clazz.getName(), invokeInfo, e});
                }
            }
        }
    }

    public void atInvokeException(Class<?> clazz, String invokeInfo, Object target, Throwable throwable) {
        ClassLoader classLoader = clazz.getClassLoader();
        String[] info = StringUtils.splitInvokeInfo(invokeInfo);
        String owner = info[0];
        String methodName = info[1];
        String methodDesc = info[2];
        List<AdviceListener> listeners = AdviceListenerManager.queryTraceAdviceListeners(classLoader, clazz.getName(), owner, methodName, methodDesc);
        if (listeners != null) {
            for (AdviceListener adviceListener : listeners) {
                try {
                    if (SpyImpl.skipAdviceListener(adviceListener)) continue;
                    InvokeTraceable listener = (InvokeTraceable)((Object)adviceListener);
                    listener.invokeThrowTracing(classLoader, owner, methodName, methodDesc, Integer.parseInt(info[3]));
                }
                catch (Throwable e) {
                    logger.error("class: {}, invokeInfo: {}", new Object[]{clazz.getName(), invokeInfo, e});
                }
            }
        }
    }

    private static boolean skipAdviceListener(AdviceListener adviceListener) {
        ProcessAware processAware;
        ExecStatus status;
        return adviceListener instanceof ProcessAware && ((status = (processAware = (ProcessAware)((Object)adviceListener)).getProcess().status()).equals((Object)ExecStatus.TERMINATED) || status.equals((Object)ExecStatus.STOPPED));
    }
}

