/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.url.interceptor;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.plugin.url.collector.RequestContext;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.plugin.url.interceptor.JakartaInterceptor;
import com.lubanops.apm.plugin.url.interceptor.JavaxInterceptor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class UrlInterceptor {
    private static volatile boolean isBelowTomcat10 = false;
    private static volatile boolean urlInterceptFlag = false;

    public static boolean hasJavaxServlet(Object request) {
        if (!urlInterceptFlag) {
            try {
                Class.forName("javax.servlet.http.HttpServletRequest");
                javax.servlet.http.HttpServletRequest httpServletRequest = (javax.servlet.http.HttpServletRequest)request;
                isBelowTomcat10 = true;
            }
            catch (Exception e) {
                isBelowTomcat10 = false;
            }
            urlInterceptFlag = true;
        }
        return isBelowTomcat10;
    }

    public static void before(Object request, Object response, String className, String methodName, String type) {
        if (UrlInterceptor.hasJavaxServlet(request)) {
            JavaxInterceptor.before((javax.servlet.http.HttpServletRequest)request, (HttpServletResponse)response, className, methodName, type);
        } else {
            JakartaInterceptor.before((HttpServletRequest)request, (jakarta.servlet.http.HttpServletResponse)response, className, methodName, type);
        }
    }

    public static void after(Object request, Object response, String type) {
        if (UrlInterceptor.hasJavaxServlet(request)) {
            JavaxInterceptor.after((javax.servlet.http.HttpServletRequest)request, (HttpServletResponse)response, type, ((HttpServletResponse)response).getStatus());
        } else {
            JakartaInterceptor.after((HttpServletRequest)request, (jakarta.servlet.http.HttpServletResponse)response, type, ((jakarta.servlet.http.HttpServletResponse)response).getStatus());
        }
    }

    public static void saveAsyncData(TransformAccess args) {
        Object context = args.getLopsAttribute();
        if (context != null && context instanceof RequestContext) {
            SpanEvent spanEvent = ((RequestContext)context).getSpanEvent();
            Map map = ((RequestContext)context).getMap();
            List txName = ((RequestContext)context).getTxName();
            String gTraceId = ((RequestContext)context).getgTraceId();
            String userFlag = ((RequestContext)context).getUserFlag();
            String policyId = ((RequestContext)context).getPolicyId();
            args.setLopsAttribute(null);
            TraceCollector.setSpanEvent((SpanEvent)spanEvent);
            TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
            TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gTraceId);
            TraceCollector.POLICY_ID_THREAD_LOCAL.set(policyId);
            UrlStatsCollector.setThreadLocalMap((Map)map);
            TransactionCollector.setTxName((List)txName);
        }
    }

    public static void clearAsyncData(TransformAccess args) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        Map map = UrlStatsCollector.getThreadLocalMap();
        List txName = TransactionCollector.getTxName();
        TraceCollector.clear();
        TransactionCollector.clear();
        UrlStatsCollector.clearThreadLocal();
        RequestContext requestContext = new RequestContext();
        requestContext.setSpanEvent(spanEvent);
        requestContext.setMap(map);
        requestContext.setTxName(txName);
        args.setLopsAttribute((Object)requestContext);
    }
}

