/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.consumer.collector;

import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.consumer.stats.RocketMqPullStats;
import java.util.List;
import java.util.Map;

public abstract class RocketMqBasicPullAggregator
extends MultiPrimaryKeyAggregator<RocketMqPullStats> {
    protected final ThreadLocal<Long> startTimeLocal = new ThreadLocal();
    protected final ThreadLocal<RocketMqPullStats> statsLocal = new ThreadLocal();
    protected final ThreadLocal<Boolean> errorLocal = new ThreadLocal();

    public void incrementPulledMsgCount(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPulledMsgCount(count);
        }
    }

    public void incrementPulledMsgCountAsync(Map<String, Object> record, int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)record.get("stats"));
        Long startTime = (Long)record.get("startTime");
        if (stats != null && startTime != null) {
            stats.incrementPulledMsgCount(count);
        }
    }

    public void incrementPulledMsgBytes(int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null) {
            stats.incrementPulledMsgBytes(count);
        }
    }

    public void incrementPulledMsgBytesAsync(Map<String, Object> record, int count) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)record.get("stats"));
        Long startTime = (Long)record.get("startTime");
        if (stats != null && startTime != null) {
            stats.incrementPulledMsgBytes(count);
        }
    }

    public void onError(String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = this.statsLocal.get();
        if (stats != null) {
            stats.onError(errorTraceId);
            this.errorLocal.set(Boolean.TRUE);
        }
    }

    public void onErrorAsync(Map<String, Object> record, String errorTraceId) {
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)record.get("stats"));
        if (stats != null) {
            stats.onError(errorTraceId);
            record.put("hasError", Boolean.TRUE);
        }
    }

    public void onFinally() {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = this.statsLocal.get();
        Long startTime = this.startTimeLocal.get();
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime)) {
            stats.setSlowTraceId(TraceCollector.getTraceId());
        }
        this.statsLocal.remove();
        this.startTimeLocal.remove();
        this.errorLocal.remove();
    }

    public void onFinallyAsync(Map<String, Object> record) {
        long timeUsed;
        if (!this.isEnable) {
            return;
        }
        RocketMqPullStats stats = (RocketMqPullStats)((Object)record.get("stats"));
        Long startTime = (Long)record.get("startTime");
        SpanEvent spanEvent = (SpanEvent)record.get("spanEvent");
        if (stats != null && startTime != null && stats.onFinally(timeUsed = System.nanoTime() - startTime) && spanEvent != null) {
            stats.setSlowTraceId(spanEvent.getTraceId());
        }
    }

    protected abstract List<String> primaryKey();

    public abstract String getName();
}

