/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.collector.AsyncProxyCreate;
import com.lubanops.apm.bootstrap.plugin.interceptor.AsyncLocal;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import io.opentelemetry.api.trace.Span;
import java.util.List;

public class AsyncInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            SpanEvent spanEvent = TraceCollector.getSpanEvent();
            if (spanEvent != null && spanEvent.getNextSpanId() != null) {
                return null;
            }
            Boolean context = AsyncLocal.CONTEXT.get();
            if (context != null) {
                return null;
            }
            AsyncLocal.CONTEXT.set(Boolean.TRUE);
            if (args[0] != null) {
                String argsClassName = args[0].getClass().getName();
                if (args[0] instanceof TransformAccess || argsClassName.startsWith("sun.") || argsClassName.startsWith("java.") || argsClassName.startsWith("javax.") || argsClassName.contains("Lambda")) {
                    String traceId = null;
                    String nextSpanId = null;
                    String otelTraceId = null;
                    String otelSpanId = null;
                    spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"ASYNC_THREAD");
                    AsyncLocal.ONSTART.set(Boolean.TRUE);
                    if (spanEvent != null) {
                        TraceCollector.addTag((String)"RunnableName", (String)args[0].getClass().getName());
                        nextSpanId = spanEvent.generateNextSpanId();
                        traceId = spanEvent.getTraceId();
                        if (nextSpanId != null && nextSpanId.length() > 100) {
                            nextSpanId = null;
                            traceId = null;
                        }
                        if (spanEvent.getOtelSpan() != null) {
                            otelSpanId = TraceCollector.getOtelSpanId((Span)spanEvent.getOtelSpan());
                            otelTraceId = TraceCollector.getOtelTraceId((Span)spanEvent.getOtelSpan());
                        }
                    }
                    String gtraceId = TraceCollector.getVirtualTraceId();
                    List txName = TransactionCollector.getTxName();
                    String userFlag = TraceCollector.getUserFlag();
                    String txTag = ProfilerService.getInstance().getTxTag();
                    String policyId = TraceCollector.getPolicyId();
                    if (traceId != null || gtraceId != null || userFlag != null) {
                        args[0] = AsyncProxyCreate.getProxyObject(args[0], traceId, nextSpanId, gtraceId, txName, userFlag, txTag, policyId, otelTraceId, otelSpanId);
                        return args;
                    }
                }
            }
        }
        catch (Exception e) {
            LogFactory.getLogger().log(Level.SEVERE, "AsyncInterceptor onStart error", (Throwable)e);
        }
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Boolean bl = AsyncLocal.CONTEXT.get();
            if (bl != null) {
                AsyncLocal.CONTEXT.remove();
                if (AsyncLocal.ONSTART.get() != null) {
                    AsyncLocal.ONSTART.remove();
                    TraceCollector.onFinally();
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

