/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb;

import java.util.List;
import java.util.Map;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MongoParser {
    public static String parseCommand(BsonDocument doc, int maxLength, boolean isParseOrigin) {
        String parsedString = MongoParser.parseCommandHelper(doc, maxLength, new StringBuilder(), isParseOrigin);
        return MongoParser.truncateParsedString(parsedString, maxLength);
    }

    public static String parseBsonDocumentList(List<BsonDocument> list, int maxLength, boolean isParseOrigin) {
        StringBuilder cur = new StringBuilder();
        BsonArray arr = new BsonArray(list);
        MongoParser.handleBsonArray(arr, maxLength, cur, isParseOrigin);
        return cur.toString();
    }

    private static String truncateParsedString(String parsedString, int maxLength) {
        int len = Math.min(maxLength, parsedString.length());
        String res = parsedString.substring(0, len);
        if (maxLength < res.length()) {
            res = res + "...";
        }
        return res;
    }

    private static String parseCommandHelper(BsonDocument doc, int maxLength, StringBuilder cur, boolean isParseOrigin) {
        cur.append("{");
        boolean isFirstInsert = true;
        for (Map.Entry entry : doc.entrySet()) {
            if (!isFirstInsert) {
                cur.append(", ");
                maxLength -= 2;
            }
            String key = (String)entry.getKey();
            cur.append("\"").append(key).append("\": ");
            maxLength = maxLength - 5 - key.length();
            if (maxLength < 0) {
                return cur.toString();
            }
            BsonValue value = (BsonValue)entry.getValue();
            String valueStr = value.isString() && (isFirstInsert || key.equals("collection")) ? "\"" + ((BsonString)value).getValue() + "\"" : MongoParser.bsonValueToString(value, maxLength, isParseOrigin);
            int valueLen = valueStr.length();
            cur.append(valueStr);
            if ((maxLength -= valueLen) < 0) {
                return cur.toString();
            }
            isFirstInsert = false;
        }
        cur.append("}");
        return cur.toString();
    }

    public static String bsonValueToString(BsonValue bsonVal, int maxLength, boolean isParseOrigin) {
        StringBuilder cur = new StringBuilder();
        if (maxLength > 0) {
            if (bsonVal.isDocument()) {
                MongoParser.handleBsonDocument((BsonDocument)bsonVal, maxLength, cur, isParseOrigin);
            } else if (bsonVal.isArray()) {
                MongoParser.handleBsonArray((BsonArray)bsonVal, maxLength, cur, isParseOrigin);
            } else if (isParseOrigin) {
                cur.append(bsonVal.toString());
            } else {
                cur.append("?");
            }
        }
        return cur.toString();
    }

    private static void handleBsonDocument(BsonDocument doc, int maxLength, StringBuilder cur, boolean isParseOrigin) {
        cur.append("{");
        boolean isFirstInsert = true;
        for (Map.Entry entry : doc.entrySet()) {
            if (!isFirstInsert) {
                cur.append(", ");
                maxLength -= 2;
            } else {
                isFirstInsert = false;
            }
            String key = (String)entry.getKey();
            cur.append("\"").append(key).append("\": ");
            maxLength = maxLength - 5 - key.length();
            if (maxLength < 0) {
                return;
            }
            String valueStr = MongoParser.bsonValueToString((BsonValue)entry.getValue(), maxLength, isParseOrigin);
            int valueLen = valueStr.length();
            cur.append(valueStr);
            if ((maxLength -= valueLen) >= 0) continue;
            return;
        }
        cur.append("}");
    }

    private static void handleBsonArray(BsonArray arr, int maxLength, StringBuilder cur, boolean isParseOrigin) {
        List valList = arr.getValues();
        cur.append("[");
        --maxLength;
        boolean isFirstInsert = true;
        boolean isAllQuestionMark = true;
        StringBuilder temp = new StringBuilder();
        for (BsonValue value : valList) {
            if (!isFirstInsert) {
                temp.append(", ");
                maxLength -= 2;
            } else {
                isFirstInsert = false;
            }
            String valueStr = MongoParser.bsonValueToString(value, maxLength, isParseOrigin);
            if (isAllQuestionMark && !valueStr.equals("?")) {
                isAllQuestionMark = false;
            }
            int valueLen = valueStr.length();
            temp.append(valueStr);
            if ((maxLength -= valueLen) >= 0) continue;
            cur.append((CharSequence)temp);
            return;
        }
        if (isAllQuestionMark) {
            cur.append("? ... ?");
        } else {
            cur.append((CharSequence)temp);
        }
        cur.append("]");
    }
}

