/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.collector;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.mongodb.ClusterObjectHolder;
import com.mongodb.connection.ClusterId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MongoClusterInfoAggregator
extends AbstractAggregator {
    public List<MonitorDataRow> harvest() {
        return this.getAllStatus();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public String getName() {
        return "clusterInfo";
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        String clusterId = primaryKeyMap.get("clusterId");
        if (clusterId == null) {
            return null;
        }
        CopyOnWriteArrayList<Object> clusterList = ClusterObjectHolder.getClusterList();
        for (Object o : clusterList) {
            MonitorDataRow row = this.buildRow(o);
            if (row == null || !clusterId.equals(row.get((Object)"clusterId"))) continue;
            return row;
        }
        return null;
    }

    private MonitorDataRow buildRow(Object cluster) {
        Integer id = (Integer)TransformAccessUtils.getFromLopsAttributeMap((Object)cluster, (String)"clusterId");
        if (id == null) {
            return null;
        }
        if (cluster instanceof TransformAccess && cluster instanceof AttributeAccess) {
            MonitorDataRow row = new MonitorDataRow();
            ClusterId clusterId = (ClusterId)((AttributeAccess)cluster).getLopsFileds()[0];
            row.add("clusterId", (Object)String.valueOf(id));
            row.add("hosts", (Object)ClusterObjectHolder.getHostsByMongoClusterId(clusterId));
            return row;
        }
        return null;
    }

    public void clear() {
    }

    public List<MonitorDataRow> getAllStatus() {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        CopyOnWriteArrayList<Object> clusterList = ClusterObjectHolder.getClusterList();
        for (Object cluster : clusterList) {
            MonitorDataRow row = this.buildRow(cluster);
            if (row == null) continue;
            result.add(row);
        }
        return result;
    }

    public void parseParameters(Map<String, String> parameters) {
    }
}

