/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dubbo.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.collector.api.PrimaryKey;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.sample.SampleConfig;
import com.lubanops.apm.bootstrap.sample.SampleType;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.dubbo.collector.DubboInvocationStats;
import com.lubanops.apm.plugin.dubbo.collector.constant.DubboTags;
import com.lubanops.apm.plugin.dubbo.collector.sampling.DubboSampleStatsConfig;
import com.lubanops.apm.plugin.dubbo.collector.sampling.MethodConfig;
import com.lubanops.apm.plugin.dubbo.collector.sampling.MethodPattern;
import com.lubanops.apm.plugin.dubbo.collector.utils.DubboCollectorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DubboInvocationAggregator
extends MultiPrimaryKeyAggregator<DubboInvocationStats> {
    private static final String MODEL_NAME_DETAIL = "invocation";
    private static final String AGGREGATE_KEY_TOTAL = "total";
    private static final String SOURCE_KEY = "source";
    private static final Logger LOGGER = LogFactory.getLogger();
    private final AtomicInteger sampleCount = new AtomicInteger(0);
    private final AtomicInteger invokeCount = new AtomicInteger(0);
    private final DubboSampleStatsConfig sampleStatsConfig = new DubboSampleStatsConfig();
    private List<PrimaryKey> slowMethod = new ArrayList<PrimaryKey>();
    private List<PrimaryKey> errorMethod = new ArrayList<PrimaryKey>();

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(DubboTags.serviceUniqueName.name(), DubboTags.method.name());
    }

    protected Class<DubboInvocationStats> getValueType() {
        return DubboInvocationStats.class;
    }

    public String getName() {
        return MODEL_NAME_DETAIL;
    }

    public long onStart(String serviceUniqueName, String method) {
        if (!this.isEnable()) {
            return 0L;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{serviceUniqueName, method});
        DubboInvocationStats sectionStats = (DubboInvocationStats)this.getValue(pk);
        long start = sectionStats.onStart();
        return start;
    }

    public boolean onError(Throwable th, long startTime, String traceId, String serviceUniqueName, String method) {
        if (!this.isEnable()) {
            return false;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{serviceUniqueName, method});
        DubboInvocationStats stat = (DubboInvocationStats)this.getValue(pk);
        if (stat != null && startTime > 0L) {
            stat.onError(th, traceId);
            return true;
        }
        return false;
    }

    public void onResponse(long startTime, String traceId, String serviceUniqueName, String method) {
        if (!this.isEnable()) {
            return;
        }
        PrimaryKey pk = new PrimaryKey(new String[]{serviceUniqueName, method});
        DubboInvocationStats stat = (DubboInvocationStats)this.getValue(pk);
        if (stat != null && startTime > 0L) {
            stat.onResponse(startTime, traceId);
        }
    }

    public boolean sample(String serviceUniqueName, String method) {
        this.invokeCount.addAndGet(1);
        PrimaryKey pk = new PrimaryKey(new String[]{serviceUniqueName, method});
        String group = DubboCollectorUtil.parseGroup(serviceUniqueName);
        String service = DubboCollectorUtil.parseService(serviceUniqueName);
        String version = DubboCollectorUtil.parserVersion(serviceUniqueName);
        if (this.sampleStatsConfig.isExclude(group, service, version, method)) {
            return false;
        }
        MethodConfig sampleConfig = this.sampleStatsConfig.getSampleConfig(group, service, version, method);
        String type = sampleConfig.getSampleType();
        if (type == null) {
            type = SampleType.automatic.value();
        }
        if (SampleType.automatic.value().equals(type)) {
            if (this.getErrorMethod().contains(pk)) {
                return this.resolveSampleStat(pk, this.sampleStatsConfig.errorRequestTraceCounStats);
            }
            if (this.getSlowMethod().contains(pk)) {
                return this.resolveSampleStat(pk, this.sampleStatsConfig.slowRequestTraceCountStats);
            }
            return this.resolveSampleStat(pk, this.sampleStatsConfig.requestTraceCountStats);
        }
        if (SampleType.all.value().equals(type)) {
            return true;
        }
        if (SampleType.frequency.value().equals(type)) {
            return this.sampleFrequency(pk, sampleConfig);
        }
        if (SampleType.percentage.value().equals(type)) {
            return this.samplePercentage(pk, sampleConfig);
        }
        return false;
    }

    private boolean resolveSampleStat(PrimaryKey pk, Stats stats) {
        DubboInvocationStats invocationStats = (DubboInvocationStats)this.obtainValue(pk);
        if (invocationStats == null) {
            return false;
        }
        int sampleCount = this.sampleCount.addAndGet(1);
        int perSampleCount = invocationStats.getSampleCount().addAndGet(1);
        if (sampleCount <= stats.getThreshold() || perSampleCount <= stats.getMinPerUrl()) {
            return true;
        }
        this.sampleCount.decrementAndGet();
        invocationStats.getSampleCount().decrementAndGet();
        return false;
    }

    private boolean sampleFrequency(PrimaryKey pk, SampleConfig sampleConfig) {
        DubboInvocationStats invocationStats = (DubboInvocationStats)this.obtainValue(pk);
        AtomicInteger sampleCount = invocationStats != null ? invocationStats.getSampleCount() : this.sampleCount;
        int count = sampleCount.addAndGet(1);
        if (count < sampleConfig.getPeriodCount()) {
            return true;
        }
        sampleCount.decrementAndGet();
        return false;
    }

    private boolean samplePercentage(PrimaryKey pk, SampleConfig sampleConfig) {
        long invokeCount;
        AtomicInteger sampleCount;
        DubboInvocationStats invocationStats = (DubboInvocationStats)this.obtainValue(pk);
        if (invocationStats != null) {
            sampleCount = invocationStats.getSampleCount();
            invokeCount = invocationStats.getInvokeCount();
        } else {
            sampleCount = this.sampleCount;
            invokeCount = this.invokeCount.get();
        }
        int count = sampleCount.addAndGet(1);
        if ((long)(count * 100) / invokeCount < (long)sampleConfig.getPercentage().intValue()) {
            return true;
        }
        sampleCount.decrementAndGet();
        return false;
    }

    private List<PrimaryKey> getSlowMethod() {
        return this.slowMethod;
    }

    private void setSlowMethod(List<PrimaryKey> slowMethod) {
        this.slowMethod = slowMethod;
    }

    private List<PrimaryKey> getErrorMethod() {
        return this.errorMethod;
    }

    private void setErrorMethod(List<PrimaryKey> errorMethod) {
        this.errorMethod = errorMethod;
    }

    public void parseParameters(Map<String, String> parameters) {
        List excludeList;
        Map includeMap;
        MethodConfig methodConfig;
        Stats traceCountStats;
        Stats errorTraceCountStats;
        Stats slowTraceCountStats;
        Integer slowRequestThreshold = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"dubboSlowRequestThreshold", Integer.class);
        if (slowRequestThreshold != null && slowRequestThreshold > 0) {
            this.sampleStatsConfig.setSlowRequestThreshold(slowRequestThreshold);
        }
        if ((slowTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"slowTraceCountStats", Stats.class)) != null) {
            this.sampleStatsConfig.setSlowRequestTraceCountStats(slowTraceCountStats);
        }
        if ((errorTraceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"errorTraceCountStats", Stats.class)) != null) {
            this.sampleStatsConfig.setErrorRequestTraceCounStats(errorTraceCountStats);
        }
        if ((traceCountStats = (Stats)ParameterParseUtil.getParameterValue(parameters, (String)"traceCountStats", Stats.class)) != null) {
            this.sampleStatsConfig.setRequestTraceCountStats(traceCountStats);
        }
        if ((methodConfig = (MethodConfig)((Object)ParameterParseUtil.getParameterValue(parameters, (String)"DefaultSampleConfig", MethodConfig.class))) != null) {
            this.sampleStatsConfig.setDefaultSampleConfig(methodConfig);
        }
        if ((includeMap = (Map)ParameterParseUtil.getParameterValue(parameters, (String)"specMethods", Map.class, null)) != null && includeMap.size() > 0) {
            this.sampleStatsConfig.setIncludeList(includeMap);
        }
        if ((excludeList = (List)ParameterParseUtil.getParameterValue(parameters, (String)"excludeMethods", List.class, MethodPattern.class)) != null && excludeList.size() > 0) {
            this.sampleStatsConfig.setExcludeList(excludeList);
        }
        for (DubboInvocationStats stats : this.valueStats.values()) {
            stats.parseRange(parameters);
        }
    }

    public List<MonitorDataRow> harvest() {
        this.sampleCount.set(0);
        this.invokeCount.set(0);
        return super.harvest();
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>(1);
        if (collected == null || collected.isEmpty()) {
            return result;
        }
        MonitorDataRow totalDataRow = new MonitorDataRow();
        for (MonitorDataRow row : collected) {
            row.put((Object)SOURCE_KEY, (Object)DubboCollectorUtil.buildSourceKey((String)row.get((Object)DubboTags.serviceUniqueName.name()), (String)row.get((Object)DubboTags.method.name())));
            DubboInvocationStats.merge(row, totalDataRow);
        }
        ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
        totalRows.add(totalDataRow);
        result.put(AGGREGATE_KEY_TOTAL, totalRows);
        ArrayList<PrimaryKey> slowMethod = new ArrayList<PrimaryKey>();
        ArrayList<PrimaryKey> errorMethod = new ArrayList<PrimaryKey>();
        for (MonitorDataRow monitorDataRow : collected) {
            String serviceUniqueName = (String)monitorDataRow.get((Object)DubboTags.serviceUniqueName.name());
            String group = DubboCollectorUtil.parseGroup(serviceUniqueName);
            String service = DubboCollectorUtil.parseService(serviceUniqueName);
            String version = DubboCollectorUtil.parserVersion(serviceUniqueName);
            String method = (String)monitorDataRow.get((Object)DubboTags.method.name());
            PrimaryKey pk = new PrimaryKey(new String[]{serviceUniqueName, method});
            long errorCount = (Long)monitorDataRow.get((Object)"errorCount");
            long maxTime = (Long)monitorDataRow.get((Object)"maxTime");
            int slowRequestThreshold = this.sampleStatsConfig.getSlowRequestThreshold(group, service, version, method);
            if (errorCount > 0L) {
                errorMethod.add(pk);
                continue;
            }
            if (maxTime <= (long)slowRequestThreshold) continue;
            slowMethod.add(pk);
        }
        this.setSlowMethod(slowMethod);
        this.setErrorMethod(errorMethod);
        return result;
    }
}

