/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlCollector;
import java.sql.Connection;
import java.sql.SQLException;
import org.postgresql.jdbc.PgStatement;
import org.postgresql.util.HostSpec;

public final class PgUtils {
    public static String getHostPostPair(HostSpec hostSpec) {
        return hostSpec.getHost() + ":" + hostSpec.getPort();
    }

    public static Integer getConnectionId(PgStatement statement) throws SQLException {
        Connection connection = statement.getConnection();
        if (connection instanceof TransformAccess) {
            return (Integer)((TransformAccess)connection).getLopsAttribute();
        }
        return null;
    }

    public static void onStatementStart(String sql, Integer connectionId) {
        try {
            ConnectionStats connectionStats;
            if (connectionId != null && (connectionStats = PgsqlCollector.onConnectionStart(connectionId, sql)) != null) {
                PgsqlCollector.onStart(sql, connectionId);
            }
        }
        catch (Exception statementOnStartException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)statementOnStartException);
        }
    }

    public static void onStatementError(String sql, Throwable e) {
        try {
            PgsqlCollector.onConnectionException(e, sql);
            PgsqlCollector.onThrowable(e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)ex);
        }
    }
}

