/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.postgresql;

import com.lubanops.apm.bootstrap.otel.ConstantsTrace;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlIdThreadLocal;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.postgresql.collector.PgsqlCollector;

public class PgsqlTrace {
    public static void onStart(String className, String methodName, String parsedSql, String originSql, Integer id) {
        SpanEvent spanEvent;
        if (PgsqlCollector.INSTANCE.isEnable() && (spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"Postgresql")) != null) {
            spanEvent.addTag("sql", parsedSql, PgsqlCollector.CONFIG.getSqlSize());
            spanEvent.addTag("sqlId", (String)SqlIdThreadLocal.THREAD_LOCAL.get());
            if (PgsqlCollector.CONFIG.isParseOriginSql()) {
                spanEvent.addTag("originSql", originSql, PgsqlCollector.CONFIG.getSqlSize());
            }
            if (id != null) {
                String dBName = Helper.CONNECTION_TARGET_MAP.getResource(id.intValue());
                spanEvent.addTag("DBName", dBName);
            }
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBSystem.toString(), (Object)ConstantsTrace.AttributeDBSystemPostgreSQL.toString());
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBStatement.toString(), (Object)parsedSql);
        }
    }

    public static void onError(Throwable e) {
        if (PgsqlCollector.INSTANCE.isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public static void onFinally(int updateRowCount, int readRowCount) {
        if (PgsqlCollector.INSTANCE.isEnable()) {
            if (updateRowCount > 0) {
                TraceCollector.addTag((String)"updateRowCount", (String)String.valueOf(updateRowCount));
            }
            if (readRowCount > 0) {
                TraceCollector.addTag((String)"readRowCount", (String)String.valueOf(readRowCount));
            }
            TraceCollector.onFinally();
        }
    }
}

