/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.netty.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.plugin.netty.collector.NettyMemoryCollector;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicLong;

public class PlatformDependentInterceptor
implements Interceptor {
    private boolean isFirstIncrease = true;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        NettyMemoryCollector.onThrowable(e);
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (this.isFirstIncrease) {
            this.isFirstIncrease = false;
            AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    try {
                        Field counterFiled = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
                        counterFiled.setAccessible(true);
                        AtomicLong counter = (AtomicLong)counterFiled.get(null);
                        Field limitFiled = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_LIMIT");
                        limitFiled.setAccessible(true);
                        long limit = (Long)limitFiled.get(null);
                        NettyMemoryCollector.setDirectMemoryCounter(counter, limit);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
    }
}

