/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.dbcp.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.connectionpool.ConnectionPoolUtils;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.dbcp.collector.DbcpCollector;
import java.security.ProtectionDomain;
import org.apache.commons.dbcp2.BasicDataSource;

public class GetConnectionInterceptor
implements Interceptor {
    private static final String DBCP_BEFORE_GET_CONNECTION = "beforeGetConnection";
    private static final String DBCP_AFTER_GET_CONNECTION = "AfterGetConnection";
    private static final String ACTIVE_COUNT = "activeCount";
    private static final String POOLING_COUNT = "poolingCount";

    public GetConnectionInterceptor() {
        DbcpCollector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)BasicDataSource.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (DbcpCollector.INSTANCE.isEnable()) {
                BasicDataSource dataSource = (BasicDataSource)object;
                int activeCount = dataSource.getNumActive();
                int poolingCount = dataSource.getNumIdle();
                DbcpCollector.INSTANCE.setActiveCount(activeCount);
                DbcpCollector.INSTANCE.setPoolingCount(poolingCount);
                DbcpCollector.onStart(dataSource);
                TraceCollector.onStart((String)className, (String)methodName, (String)"DBCP");
            }
        }
        catch (Exception e3) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e3);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (DbcpCollector.INSTANCE.isEnable()) {
                DbcpCollector.onThrowable(e);
                ConnectionPoolUtils.setErrorMsg((Throwable)e);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (DbcpCollector.INSTANCE.isEnable()) {
                DbcpCollector.onFinally();
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null && (spanEvent.getChildrenEventCount() > 0 || spanEvent.getTimeUsed() >= (long)DbcpCollector.INSTANCE.getTimeSpanThreshold() || spanEvent.getHasError())) {
                    if (DbcpCollector.INSTANCE.isGetPoolInfo()) {
                        Integer activeCountBefore = DbcpCollector.INSTANCE.getActiveCount();
                        Integer poolingCountBefore = DbcpCollector.INSTANCE.getPoolingCount();
                        DbcpCollector.INSTANCE.clearCounts();
                        if (activeCountBefore != null && poolingCountBefore != null) {
                            BasicDataSource dataSource = (BasicDataSource)object;
                            int activeCountAfter = dataSource.getNumActive();
                            int poolingCountAfter = dataSource.getNumIdle();
                            String dbcpBeforeContext = "activeCount: " + activeCountBefore + "\n" + POOLING_COUNT + ": " + poolingCountBefore;
                            String dbcpAfterContext = "activeCount: " + activeCountAfter + "\n" + POOLING_COUNT + ": " + poolingCountAfter;
                            spanEvent.addTag(DBCP_BEFORE_GET_CONNECTION, dbcpBeforeContext);
                            spanEvent.addTag(DBCP_AFTER_GET_CONNECTION, dbcpAfterContext);
                        }
                    }
                    TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e4) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e4);
        }
    }
}

